package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Relvar;
import be.SIRAPRISE.client.jsba.RelvarCardinality;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class RelvarsManage extends RelvarsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedRelvarName ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		Relvar relvar = getRelvar(siraPriseServer);

		// switch from 'select relvar' presentation to 'manage some particular relvar's details' presentation
		setPresentation("RelvarsManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		saveInFunctionContext("RELVAR", relvar); //$NON-NLS-1$
		String relvarName = relvar.getName();
		setPresentationValue("RELVARNAME", relvarName); //$NON-NLS-1$
		setPresentationValue("PREDICATE", relvar.getPredicate()); //$NON-NLS-1$

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY); //$NON-NLS-1$
			AbstractRelation r_cardinality = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.RELVARCARDINALITY + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if (r_cardinality.size() > 0) {
				setPresentationValue("CARDINALITY", r_cardinality.toObjectCollection(RelvarCardinality.class).iterator().next().getCardinality()); //$NON-NLS-1$
			}

			refreshInfo(relvarName, startTransaction);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/**
	 * @param relvarName
	 * @param startTransaction
	 * @throws WaarException
	 * @throws ConnectionClosedException
	 * @throws ErrorMessageException
	 */
	private void refreshInfo (String relvarName, DBTransaction startTransaction) throws WaarException, ConnectionClosedException, ErrorMessageException {
		String q0 = "RESTRICT(LEFTJOIN(JOIN(RELVARATTRIBUTE,LEFTJOIN(ATTRIBUTE,ATTRIBUTELOGICALLENGTH,(LOGICALLENGTH(INT(-1))))),ATTRIBUTEVALUEDISTRIBUTION,(VALUECOUNT(LONG(-1))FREQUENCY(FLOAT(-1))STDDEV(FLOAT(-1)))),EQ(RELVARNAME,NAME(" + relvarName + ")))"; //$NON-NLS-1$//$NON-NLS-2$
		String relvarNameCondition = ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String q1 = "RESTRICT(" + RELVARNAMES.TUPLECONSTRAINT + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$
		String q2 = "RESTRICT(UNION(EXTEND(SEMIMINUS(" + RELVARNAMES.KEY + "," + RELVARNAMES.KEYATTRIBUTE + "),KEYATTRIBUTES(RELATION(HEADING(" + ATTRIBUTENAMES.ATTRIBUTENAME + "(NAME))BODY()))),GROUP(JOIN(" + RELVARNAMES.KEY + "," + RELVARNAMES.KEYATTRIBUTE + "),KEYATTRIBUTES(" + ATTRIBUTENAMES.ATTRIBUTENAME + "))),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))" + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
		String q3 = "RESTRICT(UNION(EXTEND(SEMIMINUS(" + RELVARNAMES.RECORDTYPE + "," + RELVARNAMES.RECORDATTRIBUTE + "),RECORDATTRIBUTES(RELATION(HEADING(" + ATTRIBUTENAMES.ATTRIBUTENAME + "(NAME))BODY()))),GROUP(JOIN(" + RELVARNAMES.RECORDTYPE + ",PROJECT(" + RELVARNAMES.RECORDATTRIBUTE + ",(" + ATTRIBUTENAMES.RELVARNAME + "," + ATTRIBUTENAMES.RECORDTYPENAME + "," + ATTRIBUTENAMES.ATTRIBUTENAME + "))),RECORDATTRIBUTES(" + ATTRIBUTENAMES.ATTRIBUTENAME + ")))" + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
		String q4 = "PROJECT(GROUP(RESTRICT(JOIN(" + RELVARNAMES.DATABASECONSTRAINTCHECK + "," + RELVARNAMES.DATABASECONSTRAINT + ")" + relvarNameCondition + "),D_OPERATIONTYPES(" + ATTRIBUTENAMES.OPERATIONTYPE + ")),(D_OPERATIONTYPES," + ATTRIBUTENAMES.RELVARNAME + "," + ATTRIBUTENAMES.ERRORCODE + "," + ATTRIBUTENAMES.CONSTRAINTLABEL + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
//		String q5 = "RESTRICT(" + RELVARNAMES.TRANSACTIONCONSTRAINT + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$
		String q6 = "PROJECT(GROUP(RESTRICT(JOIN(" + RELVARNAMES.ASSIGNMENTCONSTRAINTCHECK + "," + RELVARNAMES.ASSIGNMENTCONSTRAINT + ")" + relvarNameCondition + "),A_OPERATIONTYPES(" + ATTRIBUTENAMES.OPERATIONTYPE + ")),(A_OPERATIONTYPES," + ATTRIBUTENAMES.RELVARNAME + "," + ATTRIBUTENAMES.ERRORCODE + "," + ATTRIBUTENAMES.CONSTRAINTLABEL + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		String q7 = "PROJECT(RESTRICT(" + RELVARNAMES.TRIGGEREDDATAACTION + relvarNameCondition + "),(" + ATTRIBUTENAMES.DATAACTIONNAME + "," + ATTRIBUTENAMES.OPERATIONTYPE + "," + ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE + "," + ATTRIBUTENAMES.TARGETRELVARNAME + "," + ATTRIBUTENAMES.ISDISTINCT + "," + ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		String q8 = "PROJECT(RESTRICT(" + RELVARNAMES.TRIGGEREDDATAACTION + ",EQ(" + ATTRIBUTENAMES.TARGETRELVARNAME + ",NAME(" + relvarName + "))" + "),(" + ATTRIBUTENAMES.DATAACTIONNAME + "," + ATTRIBUTENAMES.RELVARNAME + "," + ATTRIBUTENAMES.OPERATIONTYPE + "," + ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE + "," + ATTRIBUTENAMES.ISDISTINCT + "," + ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
		AbstractRelation[] rsp = startTransaction.execQueries(new String[] { q0, q1, q2, q3, q4, q6, q7, q8 });

		HashSet<String> stringSet = new HashSet<String>();
		stringSet.add(ATTRIBUTENAMES.SP_EXPRESSION);
		stringSet.add(ATTRIBUTENAMES.CONSTRAINTLABEL);

		setPresentationValue("ATTRIBUTELIST", getWAARListValue("ATTRIBUTELIST", rsp[0], null)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("CONSTRAINTLIST", getWAARListValue("CONSTRAINTLIST", rsp[1], stringSet)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("KEYLIST", getWAARListValue("KEYLIST", rsp[2], null)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("RECORDTYPELIST", getWAARListValue("RECORDTYPELIST", rsp[3], null)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("DATABASECONSTRAINTLIST", getWAARListValue("DATABASECONSTRAINTLIST", rsp[4], stringSet)); //$NON-NLS-1$ //$NON-NLS-2$
//		setPresentationValue("TRANSACTIONCONSTRAINTLIST", getWAARListValue("TRANSACTIONCONSTRAINTLIST", rsp[5], stringSet)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("ASSIGNMENTCONSTRAINTLIST", getWAARListValue("ASSIGNMENTCONSTRAINTLIST", rsp[5], stringSet)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("TRIGGEREDACTIONSLIST", getWAARListValue("TRIGGEREDACTIONSLIST", rsp[6], null)); //$NON-NLS-1$ //$NON-NLS-2$
		setPresentationValue("TRIGGERINGACTIONSLIST", getWAARListValue("TRIGGERINGACTIONSLIST", rsp[7], null)); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null) {
			processSelectedRelvarName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RELVARSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedRelvarName();
		} else {
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			// OK pressed on RELVARSMANAGEDETAILS presentation ===> update of predicate
			Relvar relvar = (Relvar) getFromFunctionContextMandatory(RELVARNAMES.RELVAR);

			String newPredicate = ((GenericStringValue) getPresentationValue("PREDICATE")).getString().trim(); //$NON-NLS-1$
			relvar.setPredicate(newPredicate);
			String newRelvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
			relvar.setName(newRelvarName);

			try {
				LinkedList<Object> cmds = new LinkedList<Object>(Arrays.asList(new DmlUpdateCommand[] { relvar.dbUpdateCommand(RELVARNAMES.RELVAR) }));
				String oldRelvarName = ((Relvar) relvar.getPreUpdateState()).getName();
				boolean rename = !newRelvarName.equalsIgnoreCase(oldRelvarName);

				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
					if (rename) {
						String oldRelvarNameCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + oldRelvarName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
						String fullRenameScalarUpdate = "(" + ATTRIBUTENAMES.RELVARNAME + "(,NAME(" + newRelvarName + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
						cmds.addLast("UPDATE " + RELVARNAMES.TUPLECONSTRAINT + ",RESTRICT(" + RELVARNAMES.TUPLECONSTRAINT + "," + oldRelvarNameCondition + ")," + fullRenameScalarUpdate); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
//						cmds.addLast("UPDATE " + RELVARNAMES.TRANSACTIONCONSTRAINT + ",RESTRICT(" + RELVARNAMES.TRANSACTIONCONSTRAINT + "," + oldRelvarNameCondition + ")," + fullRenameScalarUpdate); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						cmds.addLast("UPDATE " + RELVARNAMES.KEYATTRIBUTE + ",RESTRICT(" + RELVARNAMES.KEYATTRIBUTE + "," + oldRelvarNameCondition + ")," + fullRenameScalarUpdate); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						cmds.addLast("UPDATE " + RELVARNAMES.KEY + ",RESTRICT(" + RELVARNAMES.KEY + "," + oldRelvarNameCondition + ")," + fullRenameScalarUpdate); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						cmds.addLast("UPDATE " + RELVARNAMES.RELVARATTRIBUTE + ",RESTRICT(" + RELVARNAMES.RELVARATTRIBUTE + "," + oldRelvarNameCondition + ")," + fullRenameScalarUpdate); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					startTransaction.execMultipleStatement(cmds);
					refreshInfo(newRelvarName, startTransaction);
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e1) {

			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			refreshInfo(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim(), dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY)); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RELVARSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}