package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class RelvarsOverview extends RelvarsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue("NAMEPATTERN") != null || getPresentationValue(ATTRIBUTENAMES.FILENAME) != null) { //$NON-NLS-1$
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue namePattern = (GenericStringValue) getPresentationValue("NAMEPATTERN"); //$NON-NLS-1$
		String queryExpression;
		if (namePattern != null) {
			queryExpression = "RESTRICT(" + RELVARNAMES.RELVAR + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + BracketParser.meta(namePattern.getString()) + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		} else {
			queryExpression = RELVARNAMES.RELVAR;
		}

		WaarValue wv_fileName = getPresentationValue(ATTRIBUTENAMES.FILENAME);
		WaarValue wv_dataSpaceID = getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID);

		if (wv_fileName != null) {
			String fileName = ((GenericStringValue) wv_fileName).getString().trim();
			String restrictCondition = "EQ(" + ATTRIBUTENAMES.FILENAME + "," + TYPENAMES.FILENAME + "(" + fileName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if (wv_dataSpaceID != null) {
				restrictCondition = "AND(" + restrictCondition + ",EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + ((GenericIntegerValue) wv_dataSpaceID).getInteger() + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
			queryExpression = "JOIN(" + queryExpression + ",PROJECT(RESTRICT(" + RELVARNAMES.RECORDTYPE + "," + restrictCondition + "),(" + ATTRIBUTENAMES.RELVARNAME + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ 
		} else {
			if (wv_dataSpaceID != null) {
				throw new StorageSpaceIDWithoutFileNameException(getUserLocale());
			}
		}

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			setPresentationValue("RELVARLIST", getWAARListValue("RELVARLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("JOIN(" + queryExpression + "," + RELVARNAMES.RELVARID + ")"), new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.RELVARPREDICATE })))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}