/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Relvar;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 *
 */
public abstract class RelvarsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String RELVARSSELECT = "RelvarsSelect"; //$NON-NLS-1$

	/**
	 * @param siraPriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws NoSuchRelvarException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final Relvar getRelvar (SiraPriseServer siraPriseServer) throws NoConnectionException, NoSuchRelvarException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
			AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.RELVAR + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	
			// Set tuples = rsp.getTupleSet();
			if (rsp.size() == 0) {
				throw new NoSuchRelvarException(relvarName, getUserLocale());
			}
			return rsp.toObjectCollection(Relvar.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

}
