package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.DBException;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class ShutdownEngine extends SiraPriseWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerMonitorPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerMonitorPortPresentationValues();
		try {
			getMonitorConnection(sirapriseServer.getServer().trim(), sirapriseServer.getMonitorport()).execCommand("SHUTDOWN", getUserData().getUserID(), null, true); //$NON-NLS-1$
		} catch (DBException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ShutdownEngine.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}
