/*
 * Created on 30-sep-2008
 */
package be.SIRAPRISE.webclient;

/**
 * @author Erwin Smout
 */
final class SiraPriseServer {

	/**
	 * Flag indicating whether DDL capture is to be used in the session for which this object exists
	 */
	private boolean captureDDL;

	/**
	 * The monitor port number identifying the server to which can be connected
	 */
	private int monitorport;

	/**
	 * The port number identifying the server to which can be connected
	 */
	private int port;

	/**
	 * The DNS name or IP address of the server to which can be connected
	 */
	private String server;

	/**
	 * @param server
	 *            The DNS name or IP address of the server to which can be connected
	 * @param port
	 *            The port number identifying the server to which can be connected
	 * @param monitorPort
	 *            The port number identifying the server to which can be connected for monitor commands
	 * @param captureDDL
	 * 			  Flag indicating whether DDL capture is to be used in the session for which this object exists
	 */
	SiraPriseServer (String server, int port, int monitorPort, boolean captureDDL) {
		this.server = server;
		this.port = port;
		this.monitorport = monitorPort;
		this.captureDDL = captureDDL;
	}

	/**
	 * Gets The monitor port number identifying the server to which can be connected
	 * 
	 * @return The monitor port number identifying the server to which can be connected
	 */
	int getMonitorport ( ) {
		return monitorport;
	}

	/**
	 * Gets The port number identifying the server to which can be connected
	 * 
	 * @return The port number identifying the server to which can be connected
	 */
	int getPort ( ) {
		return port;
	}

	/**
	 * Gets The DNS name or IP address of the server to which can be connected
	 * 
	 * @return The DNS name or IP address of the server to which can be connected
	 */
	String getServer ( ) {
		return server;
	}

	/**
	 * Gets the flag indicating whether DDL capture is to be used in the session for which this object exists
	 *
	 * @return true if DDL capture is to be used in the session for which this object exists
	 */
	final boolean isCaptureDDL ( ) {
		return captureDDL;
	}
}
