/**
 * 
 */
package be.SIRAPRISE.webclient;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;

import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.util.MyKeyStore;
import be.erwinsmout.NotFoundException;

/**
 * @author Erwin
 * 
 */
final class SiraPriseWebClientSigner implements Signer {

	/**
	 * 
	 */
	private static Signer instance = new SiraPriseWebClientSigner();

	/**
	 * @return
	 */
	static Signer getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private HashMap<String, PrivateKey> privateKeysPerAlgorithm = new HashMap<String, PrivateKey>();

	/**
	 * Gets the private Key for signing by the web client.
	 * 
	 * @param algorithmName
	 *            The name of the algorithm that will be used for signing.
	 * @return The private Key
	 * @throws NotFoundException
	 */
	private PrivateKey getPrivateKey (String algorithmName) throws NotFoundException {
		PrivateKey privateKey = privateKeysPerAlgorithm.get(algorithmName);
		if (privateKey == null) {
			try {
				// Get the keystore
				KeyStore jks = MyKeyStore.getKeyStore(this.getClass());

				// Get the private Key from the keystore. This is the key that is stored in the webclient's configured keystore for the alias that is equal to the clientID, suffixed with the algorithm name
				privateKey = (PrivateKey) jks.getKey(SiraPriseWebClientFunction.clientName + algorithmName, this.getClass().getSimpleName().toCharArray());
				privateKeysPerAlgorithm.put(algorithmName, privateKey);
			} catch (KeyStoreException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (NoSuchAlgorithmException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (CertificateException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (IOException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (UnrecoverableKeyException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			}
		}

		return privateKey;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.Signer#sign(java.security.Signature, byte[])
	 */
	@Override
	final public byte[] sign (Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
		signature.initSign(getPrivateKey(signature.getAlgorithm()));
		signature.update(signMessage);
		return signature.sign();
	}
}
