package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.WAAR.PresentationLayer.*;

/**
 * Function to perform space calculations, v2. The function starts by asking the user for a relvar name. The actual space calculation function will always display a table of attribute names and corresponding physical sizes on the form.
 * 
 * @author Erwin
 */
public class SpaceCalculations extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	private static final String SPACECALCULATIONSSELECTRELVAR = "SpaceCalculationsSelectRelvar"; //$NON-NLS-1$

	/**
	 * @throws BothFileAndStorageSpaceException
	 * @throws FileNameAndPageSizeException
	 * @throws DBProblem
	 * @throws ExpectedBracketsMissingException
	 * @throws BothTypeAndPagesizeException
	 * @throws WaarException
	 * @throws InvalidAttributeValueException
	 * @throws NoConnectionException
	 */
	private void processData ( ) throws BothFileAndStorageSpaceException, FileNameAndPageSizeException, DBProblem, ExpectedBracketsMissingException, BothTypeAndPagesizeException, WaarException, InvalidAttributeValueException, NoConnectionException {
		GenericStringValue wv_server = (GenericStringValue) getFromFunctionContextMandatory(SiraPriseWebClientFunction.SERVER);
		GenericIntegerValue wv_port = (GenericIntegerValue) getFromFunctionContextMandatory(DBConnectionProperties.PORT);
		GenericIntegerValue wv_monitorPort = (GenericIntegerValue) getFromFunctionContextMandatory(DBConnectionProperties.MONITORPORT);
		GenericStringValue wv_relvarName = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME);
		ListValue wv_attributeList = (ListValue) getFromFunctionContextMandatory("ATTRIBUTELIST"); //$NON-NLS-1$

		setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
		setPresentationValue(DBConnectionProperties.PORT, wv_port);
		setPresentationValue(DBConnectionProperties.MONITORPORT, wv_monitorPort);
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
		setPresentationValue("ATTRIBUTELIST", wv_attributeList); //$NON-NLS-1$

		String server = wv_server.getString().trim();
		int port = wv_port.getInteger();
		int monitorport = wv_monitorPort.getInteger();

		GenericStringValue wv_fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME));
		GenericIntegerValue wv_storageSpaceID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID));
		NumberedEnumerationValue wv_storageSpaceType = ((NumberedEnumerationValue) getPresentationValue("STORAGESPACETYPE")); //$NON-NLS-1$
		GenericIntegerValue wv_pageSize = ((GenericIntegerValue) getPresentationValue("PAGESIZE")); //$NON-NLS-1$
		GenericIntegerValue wv_entryCount = ((GenericIntegerValue) getPresentationValue("ENTRYCOUNT")); //$NON-NLS-1$
		GenericIntegerValue wv_entrySize = ((GenericIntegerValue) getPresentationValue("ENTRYSIZE")); //$NON-NLS-1$
		GenericIntegerValue wv_gapCount = ((GenericIntegerValue) getPresentationValue("GAPCOUNT")); //$NON-NLS-1$

		DBConnection dbc;
		int pageSize = 0;
		String storageSpaceType_tx = ""; //$NON-NLS-1$
		if (wv_fileName != null || wv_storageSpaceID != null) {
			if (wv_fileName == null || wv_storageSpaceID == null) {
				throw new BothFileAndStorageSpaceException(getUserLocale());
			} else {
				if (wv_storageSpaceType != null || wv_pageSize != null) {
					throw new FileNameAndPageSizeException(getUserLocale());
				}
				String fileName = wv_fileName.getString().trim();
				int storageSpaceID = wv_storageSpaceID.getInteger();
				// Get the numbers from the dbms
				dbc = getDBConnection(server, port, getUserLocale());
				try {
					DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
					AbstractRelation rsp = startTransaction.execQueryAndEndTransaction("RESTRICT(JOIN(DBMSFILE,STORAGESPACE,UNION(EXTEND(PROJECT(HASHINGINDEXSPACE,(FILENAME,STORAGESPACEID)),TYPE(NAME(HASH))),EXTEND(PROJECT(DATASPACE,(FILENAME,STORAGESPACEID)),TYPE(NAME(DATA))),EXTEND(PROJECT(TREEINDEXSPACE,(FILENAME,STORAGESPACEID)),TYPE(NAME(TREE))),EXTEND(PROJECT(MULTIHASHINGINDEXSPACE,(FILENAME,STORAGESPACEID)),TYPE(NAME(MHSH))))),AND(EQ(FILENAME,FILENAME(" + fileName + ")),EQ(STORAGESPACEID,INT(" + storageSpaceID + "))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					if (rsp.size() < 1) {
						throw new StorageSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
					}
					AbstractTuple tuple = (AbstractTuple) rsp.iterator().next(); // There can be only one
					// FILENAME(...)STORAGESPACEID(...)TYPE(...)PAGESIZE(...)
					String pageSize_tx = tuple.value(ATTRIBUTENAMES.PAGESIZE);
					pageSize = Integer.parseInt(pageSize_tx);
					storageSpaceType_tx = tuple.value("TYPE"); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			}
		} else {
			if (wv_storageSpaceType == null || wv_pageSize == null) {
				throw new BothTypeAndPagesizeException(getUserLocale());
			}
			storageSpaceType_tx = ((NumberedEnumerationType) getPresentation().getPresentationField("STORAGESPACETYPE", getUserLocale()).getType()).toString(wv_storageSpaceType.getIntegerValue()); //$NON-NLS-1$
			pageSize = wv_pageSize.getInteger();
		}

		int count = wv_entryCount.getInteger();
		int entrysize = wv_entrySize.getInteger();

		String cmd = "SPACECALC ENTRYTYPE(" + storageSpaceType_tx + ")ENTRYCOUNT(" + count + ")PAGESIZE(" + pageSize + ")" + "ENTRYSIZE(" + entrysize + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
		if (wv_gapCount != null) {
			int gapcount = wv_gapCount.getInteger();
			cmd += "GAPCOUNT(" + gapcount + ")"; //$NON-NLS-1$//$NON-NLS-2$
		}
		AbstractRelation r;
		try {
			r = getMonitorConnection(server, monitorport).execCommand(cmd, getUserData().getUserID(), null, true);
		} catch (DBException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		}

		AbstractTuple tuple = (AbstractTuple) r.iterator().next(); // There can be only one
		String pageCount_tx = tuple.value(ATTRIBUTENAMES.PAGECOUNT);
		setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, GenericInteger.fromString(pageCount_tx, getUserLocale()));
		String pageSize_tx = tuple.value(ATTRIBUTENAMES.PAGESIZE);
		setPresentationValue("CALCULATEDPAGESIZE", GenericInteger.fromString(pageSize_tx, getUserLocale())); //$NON-NLS-1$
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedRelvar ( ) throws WaarException {
		GenericStringValue wv_server = ((GenericStringValue) getPresentationValue(SiraPriseWebClientFunction.SERVER));
		GenericIntegerValue wv_port = ((GenericIntegerValue) getPresentationValue(DBConnectionProperties.PORT));
		GenericIntegerValue wv_monitorPort = ((GenericIntegerValue) getPresentationValue(DBConnectionProperties.MONITORPORT));
		String server = wv_server.getString().trim();
		int port = wv_port.getInteger();

		GenericStringValue wv_relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME));
		String relvarName = wv_relvarName.getString();
		DBConnection dbc;
		dbc = getDBConnection(server, port, getUserLocale());

		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			AbstractRelation rsp = startTransaction.execQuery("RESTRICT(RELVAR,EQ(RELVARNAME,NAME(" + relvarName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$
			if (rsp.size() < 1) {
				throw new NoSuchRelvarException(relvarName, getUserLocale());
			}

			// val = TUPLE(...) , meaning the relvar name is known to the selected server ===> fetch the attributes and their sizes
			rsp = startTransaction.execQueryAndEndTransaction("RESTRICT(JOIN(RELVARATTRIBUTE,ATTRIBUTEPHYSICALLENGTH),EQ(RELVARNAME,NAME(" + relvarName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ 
			setPresentation("SpaceCalculations"); //$NON-NLS-1$
			ListValue lv = getWAARListValue("ATTRIBUTELIST", rsp, null); //$NON-NLS-1$

			setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
			saveInFunctionContext(SiraPriseWebClientFunction.SERVER, wv_server);
			setPresentationValue(DBConnectionProperties.PORT, wv_port);
			saveInFunctionContext(DBConnectionProperties.PORT, wv_port);
			setPresentationValue(DBConnectionProperties.MONITORPORT, wv_monitorPort);
			saveInFunctionContext(DBConnectionProperties.MONITORPORT, wv_monitorPort);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			setPresentationValue("ATTRIBUTELIST", lv); //$NON-NLS-1$
			saveInFunctionContext("ATTRIBUTELIST", lv); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	public void doActionLogic (String action) throws WaarException {
		if (action.equalsIgnoreCase("SELECT OTHER RELVAR")) { //$NON-NLS-1$
			setPresentation(SPACECALCULATIONSSELECTRELVAR);
			GenericStringValue wvsrv = (GenericStringValue) getFromFunctionContextMandatory(SiraPriseWebClientFunction.SERVER);
			GenericIntegerValue wvport = (GenericIntegerValue) getFromFunctionContextMandatory(DBConnectionProperties.PORT);
			GenericIntegerValue wvmonitorport = (GenericIntegerValue) getFromFunctionContextMandatory(DBConnectionProperties.MONITORPORT);
			GenericStringValue wvrelvarname = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME);
			setPresentationValue(SiraPriseWebClientFunction.SERVER, wvsrv);
			setPresentationValue(DBConnectionProperties.PORT, wvport);
			setPresentationValue(DBConnectionProperties.MONITORPORT, wvmonitorport);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wvrelvarname);
			return;
		}
		super.doActionLogic(action);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(SPACECALCULATIONSSELECTRELVAR)) {
			processSelectedRelvar();
		} else {
			processData();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return SPACECALCULATIONSSELECTRELVAR;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "SpaceCalculations.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}