package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.AbstractDBObject;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.SIRAPRISE.client.jsba.HashingIndexSpace;
import be.SIRAPRISE.client.jsba.MultiHashingIndexSpace;
import be.SIRAPRISE.client.jsba.StorageSpace;
import be.SIRAPRISE.client.jsba.TreeIndexSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a storage space.
 * 
 * @author Erwin
 */
public class StorageSpaceDelete extends StorageSpaceWebClientFunction {

	/**
	 * 
	 */
	private static final String OBJECTSTOBEDELETED = "OBJECTSTOBEDELETED"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRMATION = "StorageSpaceDeleteConfirm"; //$NON-NLS-1$

	/**
	 * flag indicating whether to leave the function or not
	 */
	private boolean leave;

	/**
	 * @throws WaarException
	 */
	@SuppressWarnings("unchecked")
	private void processDeleteConfirmation ( ) throws WaarException {
		// confirmation entered, delete file and storage spaces
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		Map<String, Collection<? extends DBObject>> objectsToBeDeleted = (Map<String, Collection<? extends DBObject>>) getFromFunctionContextMandatory(OBJECTSTOBEDELETED);
		Set<DmlAssignmentCommand> detailCommands = new HashSet<DmlAssignmentCommand>();
		for (Entry<String, Collection<? extends DBObject>> me : objectsToBeDeleted.entrySet()) {
			for (DBObject deleteObject : me.getValue()) {
				detailCommands.add(AbstractDBObject.dbDeleteCommand(me.getKey(), deleteObject));
			}
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(detailCommands); //$NON-NLS-1$
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedStorageSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_fileName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME);
		String fileName = wv_fileName.getString();
		GenericIntegerValue wv_storageSpaceID = (GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID);
		int storageSpaceID = wv_storageSpaceID.getInteger();

		// get a StorageSpace object
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction transaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String restrictCondition = "AND(EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + storageSpaceID + ")),EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			AbstractRelation r_storageSpace = transaction.execQuery("RESTRICT(" + RELVARNAMES.STORAGESPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (r_storageSpace.size() < 1) {
				throw new StorageSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}
			// StorageSpace storageSpace = (StorageSpace) ((AbstractTuple) r_storageSpace.iterator().next()).toObject(StorageSpace.class);
			Map<String, Collection<?>> objectsToBeDeleted = new HashMap<String, Collection<?>>();
			objectsToBeDeleted.put(RELVARNAMES.STORAGESPACE, r_storageSpace.toObjectCollection(StorageSpace.class));

			AbstractRelation r_dataSpace = transaction.execQuery("RESTRICT(" + RELVARNAMES.DATASPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
			if (r_dataSpace.size() > 0) {
				objectsToBeDeleted.put(RELVARNAMES.DATASPACE, r_dataSpace.toObjectCollection(DataSpace.class));
			} else {
				AbstractRelation r_treeIndexSpace = transaction.execQuery("RESTRICT(" + RELVARNAMES.TREEINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
				if (r_treeIndexSpace.size() > 0) {
					objectsToBeDeleted.put(RELVARNAMES.TREEINDEXSPACE, r_treeIndexSpace.toObjectCollection(TreeIndexSpace.class));
				} else {
					AbstractRelation r_hashingIndexSpace = transaction.execQuery("RESTRICT(" + RELVARNAMES.HASHINGINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
					if (r_hashingIndexSpace.size() > 0) {
						objectsToBeDeleted.put(RELVARNAMES.HASHINGINDEXSPACE, r_hashingIndexSpace.toObjectCollection(HashingIndexSpace.class));
					} else {
						AbstractRelation r_multiHashingIndexSpace = transaction.execQuery("RESTRICT(" + RELVARNAMES.MULTIHASHINGINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
						if (r_multiHashingIndexSpace.size() > 0) {
							objectsToBeDeleted.put(RELVARNAMES.MULTIHASHINGINDEXSPACE, r_multiHashingIndexSpace.toObjectCollection(MultiHashingIndexSpace.class));
						} else {
							throw new StorageSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
						}
					}
				}
			}

//			Relation r_storageSpaceExtents = transaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.STORAGESPACEEXTENTS + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
//			if (r_storageSpaceExtents.size() > 0) {
//				objectsToBeDeleted.put(RELVARNAMES.STORAGESPACEEXTENTS, r_storageSpaceExtents.toObjectCollection(StorageSpaceExtent.class));
//			}

			setPresentation(PRESENTATIONNAME_DELETECONFIRMATION);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.FILENAME, wv_fileName);
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, wv_storageSpaceID);

			saveInFunctionContext(OBJECTSTOBEDELETED, objectsToBeDeleted);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedStorageSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// filename entered, ask confirmation
			processSelectedStorageSpace();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "StorageSpaceDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}