package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a storage space. This is currently unsupported
 * 
 * @author Erwin
 */
public class StorageSpaceManage extends StorageSpaceWebClientFunction {

	/**
	 * flag indicating whether to leave the function or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedStorageSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString();
		int storageSpaceID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger();

		// get a StorageSpace object
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction transaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY); //$NON-NLS-1$
			String restrictCondition = "AND(EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + storageSpaceID + ")),EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			AbstractRelation tuples = transaction.execQuery("RESTRICT(" + RELVARNAMES.STORAGESPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (tuples.size() < 1) {
				throw new StorageSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}
			// Object storageSpace = ((AbstractTuple)tuples.iterator().next()).toObject(StorageSpace.class);

			tuples = transaction.execQuery("RESTRICT(" + RELVARNAMES.DATASPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
			// Object detail;
			if (tuples.size() > 0) {
				// detail = ((AbstractTuple)tuples.iterator().next()).toObject(DataSpace.class);
			} else {
				tuples = transaction.execQuery("RESTRICT(" + RELVARNAMES.TREEINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
				if (tuples.size() > 0) {
					// detail = ((AbstractTuple)tuples.iterator().next()).toObject(TreeIndexSpace.class);
				} else {
					tuples = transaction.execQuery("RESTRICT(" + RELVARNAMES.HASHINGINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
					if (tuples.size() > 0) {
						// detail = ((AbstractTuple)tuples.iterator().next()).toObject(HashingIndexSpace.class);
					} else {
						tuples = transaction.execQuery("RESTRICT(" + RELVARNAMES.MULTIHASHINGINDEXSPACE + "," + restrictCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
						if (tuples.size() > 0) {
							// detail = ((AbstractTuple)tuples.iterator().next()).toObject(MultiHashingIndexSpace.class);
						} else {
							throw new StorageSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
						}
					}
				}
			}

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedStorageSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// filename entered, ask confirmation
			processSelectedStorageSpace();
		} else {
			leave = true;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "StorageSpaceManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}