package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to produce an overview of existing storage spaces
 * 
 * @author Erwin
 */
public class StorageSpaceOverview extends StorageSpaceWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null) {
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString();
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY); //$NON-NLS-1$

			String fileNameCondition = "EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			String orderingSpec = ",(" + ATTRIBUTENAMES.STORAGESPACEID + ")"; //$NON-NLS-1$//$NON-NLS-2$
			setPresentationValue("DATASPACELIST", getWAARListValue("DATASPACELIST", startTransaction.execQuery("RESTRICT(JOIN(" + RELVARNAMES.DATASPACE + "," + RELVARNAMES.STORAGESPACE + ")," + fileNameCondition + ")" + orderingSpec), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			setPresentationValue("HASHINGINDEXSPACELIST", getWAARListValue("HASHINGINDEXSPACELIST", startTransaction.execQuery("RESTRICT(JOIN(LEFTJOIN(" + RELVARNAMES.HASHINGINDEXSPACE + "," + RELVARNAMES.INDEX + ",(INDEXNAME(NAME( ))RECORDTYPENAME(NAME( ))RELVARNAME(NAME( ))))," + RELVARNAMES.STORAGESPACE + ")," + fileNameCondition + ")" + orderingSpec), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			setPresentationValue("TREEINDEXSPACELIST", getWAARListValue("TREEINDEXSPACELIST", startTransaction.execQuery("RESTRICT(JOIN(LEFTJOIN(" + RELVARNAMES.TREEINDEXSPACE + "," + RELVARNAMES.INDEX + ",(INDEXNAME(NAME( ))RECORDTYPENAME(NAME( ))RELVARNAME(NAME( ))))," + RELVARNAMES.STORAGESPACE + ")," + fileNameCondition + ")" + orderingSpec), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			setPresentationValue("MULTIHASHINGINDEXSPACELIST", getWAARListValue("MULTIHASHINGINDEXSPACELIST", startTransaction.execQuery("RESTRICT(JOIN(" + RELVARNAMES.STORAGESPACE + "," + RELVARNAMES.MULTIHASHINGINDEXSPACE + ")," + fileNameCondition + ")" + orderingSpec), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$

			startTransaction.end(true);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "StorageSpaceOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}