package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.TransactionConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * Function to add a new transaction constraint
 * 
 * @author Erwin
 */
@Deprecated
public class TransactionConstraintsCreate extends TransactionConstraintsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
		GenericStringValue wv_constraintMessageText = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT));

		DmlAddCommand[] cmds;
		if (wv_constraintMessageText != null) {
			TransactionConstraint x = new TransactionConstraint(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim(), ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue(), errorCode, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim(), ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim(), wv_constraintMessageText.getString().trim());
			cmds = new DmlAddCommand[] { x.dbAddCommand(RELVARNAMES.TRANSACTIONCONSTRAINT), x.dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
		} else {
			cmds = new DmlAddCommand[] { new TransactionConstraint(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim(), ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue(), errorCode, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim(), ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim(), null).dbAddCommand(RELVARNAMES.TRANSACTIONCONSTRAINT) };
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TransactionConstraintsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}