package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.TransactionConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a transaction constraint and possibly its corresponding constraintmessagetext
 * 
 * @author Erwin
 */
@Deprecated
public class TransactionConstraintsDelete extends TransactionConstraintsWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedTransactionConstraint ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		TransactionConstraint transactionConstraint = getTransactionConstraint(siraPriseServer);

		saveInFunctionContext(RELVARNAMES.TRANSACTIONCONSTRAINT, transactionConstraint);

		setPresentation("TransactionConstraintsDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, transactionConstraint.getErrorCode());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, transactionConstraint.getLabel());
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, transactionConstraint.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, transactionConstraint.getExpression());
		setPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE, ((NumberedEnumerationType) getPresentation().getPresentationField(ATTRIBUTENAMES.OPERATIONTYPE, getUserLocale()).getType()).value(transactionConstraint.getOperationType(), getUserLocale()));
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, transactionConstraint.getMessageText());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedTransactionConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TRANSACTIONCONSTRAINTSSELECT)) {
			// errorcode entered, ask confirmation
			processSelectedTransactionConstraint();
		} else {
			// confirmation entered, delete constraint
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
			TransactionConstraint transactionConstraint = (TransactionConstraint) getFromFunctionContextMandatory(RELVARNAMES.TRANSACTIONCONSTRAINT);
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, transactionConstraint.getErrorCode());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, transactionConstraint.getLabel());
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, transactionConstraint.getRelvarName());
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, transactionConstraint.getExpression());
			setPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE, ((NumberedEnumerationType) getPresentation().getPresentationField(ATTRIBUTENAMES.OPERATIONTYPE, getUserLocale()).getType()).value(transactionConstraint.getOperationType(), getUserLocale()));
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, transactionConstraint.getMessageText());

			DBConnection dbc = getDBConnection(siraPriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { transactionConstraint.dbDeleteCommand(RELVARNAMES.TRANSACTIONCONSTRAINT), transactionConstraint.dbUnAssertCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) }); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TRANSACTIONCONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TransactionConstraintsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}