package be.SIRAPRISE.webclient;

import java.util.LinkedList;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.TransactionConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a database constraint
 * 
 * @author Erwin
 */
@Deprecated
public class TransactionConstraintsManage extends TransactionConstraintsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedTransactionConstraint ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
		TransactionConstraint transactionConstraint = getTransactionConstraint(siraPriseServer);

		setPresentation("TransactionConstraintsManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, transactionConstraint.getErrorCode());
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, transactionConstraint.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, transactionConstraint.getLabel());
		setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, transactionConstraint.getExpression());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, transactionConstraint.getMessageText());
		setPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE, transactionConstraint.getOperationType());

		saveInFunctionContext(RELVARNAMES.TRANSACTIONCONSTRAINT, transactionConstraint);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedTransactionConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TRANSACTIONCONSTRAINTSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedTransactionConstraint();
		} else {
			// new dbms file details entered, update the catalog
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
			TransactionConstraint transactionConstraint = (TransactionConstraint) getFromFunctionContextMandatory(RELVARNAMES.TRANSACTIONCONSTRAINT);

			String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();
			int operationType = ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue();
			long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
			String constraintLabel = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim();
			String constraintExpression = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim();
			GenericStringValue wv_constraintMessageText = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT);
			String constraintMessageText;
			if (wv_constraintMessageText != null) {
				constraintMessageText = wv_constraintMessageText.getString().trim();
			} else {
				constraintMessageText = "-"; //$NON-NLS-1$
			}

			transactionConstraint.setRelvarName(relvarName);
			transactionConstraint.setOperationType(operationType);
			transactionConstraint.setErrorCode(errorCode);
			transactionConstraint.setLabel(constraintLabel);
			transactionConstraint.setExpression(constraintExpression);
			transactionConstraint.setMessageText(constraintMessageText);

			LinkedList<DmlAssignmentCommand> cmds = new LinkedList<DmlAssignmentCommand>();
			try {
				cmds.add(transactionConstraint.dbUpdateCommand(RELVARNAMES.TRANSACTIONCONSTRAINT));
			} catch (NoUpdatesException e1) {

			}

			TransactionConstraint oldTransactionConstraint = (TransactionConstraint) transactionConstraint.getPreUpdateState();
			DmlAssignmentCommand cmd2 = null;
			if (oldTransactionConstraint.getMessageText() == null || oldTransactionConstraint.getMessageText().equals("-")) { //$NON-NLS-1$
				if (transactionConstraint.getMessageText() == null || transactionConstraint.getMessageText().equals("-")) { //$NON-NLS-1$
					// no update to be done to the messagetext
				} else {
					cmd2 = transactionConstraint.dbAddCommand(RELVARNAMES.TRANSACTIONCONSTRAINT);
				}
			} else {
				if (transactionConstraint.getMessageText() == null || transactionConstraint.getMessageText().equals("-")) { //$NON-NLS-1$
					cmd2 = transactionConstraint.dbDeleteCommand(RELVARNAMES.TRANSACTIONCONSTRAINT);
				} else {
					try {
						cmd2 = transactionConstraint.dbUpdateCommand(RELVARNAMES.TRANSACTIONCONSTRAINT);
					} catch (NoUpdatesException e) {

					}
				}
			}
			if (cmd2 != null) {
				cmds.add(cmd2);
			}

			if (cmds.size() > 0) {
				DBConnection dbc = getDBConnection(siraPriseServer);
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TRANSACTIONCONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TransactionConstraintsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}