package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.TreeIndexSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a multiple hashing index space from a dbms file
 * 
 * @author Erwin
 */
public class TreeIndexSpaceDelete extends StorageSpaceWebClientFunction {

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRMATION = "TreeIndexSpaceConfirmDelete"; //$NON-NLS-1$

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	private void processDeleteConfirmation ( ) throws WaarException, NoConnectionException, DBProblem, WAARApplicationException {
		TreeIndexSpace treeIndexSpace = (TreeIndexSpace) getFromFunctionContextMandatory(RELVARNAMES.TREEINDEXSPACE);
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlDeleteCommand[] { treeIndexSpace.dbDeleteCommand(RELVARNAMES.STORAGESPACE), treeIndexSpace.dbDeleteCommand(RELVARNAMES.TREEINDEXSPACE) }); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedTreeIndexSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME));
		String fileName = wv_fileName.getString().trim();
		GenericIntegerValue wv_storageSpaceID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID));
		int storageSpaceID = wv_storageSpaceID.getInteger();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation r_treeIndexSpace = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(JOIN(" + RELVARNAMES.TREEINDEXSPACE + "," + RELVARNAMES.STORAGESPACE + "),AND(EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + storageSpaceID + ")),EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + "))))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			if (r_treeIndexSpace.size() < 1) {
				// filename not found
				throw new TreeIndexSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}

			TreeIndexSpace treeIndexSpace = DBObjectFactory.getObject(r_treeIndexSpace.iterator().next(), TreeIndexSpace.class);

			setPresentation(PRESENTATIONNAME_DELETECONFIRMATION);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.FILENAME, wv_fileName);
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, wv_storageSpaceID);
			setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, treeIndexSpace.getPageCount());
			setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, treeIndexSpace.getExtentsCount());

			saveInFunctionContext(RELVARNAMES.TREEINDEXSPACE, treeIndexSpace);

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedTreeIndexSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// errorcode entered, ask confirmation
			processSelectedTreeIndexSpace();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TreeIndexSpaceDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}