package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.TriggeredDataAction;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class TriggeredDataActionsCreate extends TriggeredDataActionsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		String actionName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.DATAACTIONNAME)).getString().trim();
		String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
		int operationType = ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE)).getIntegerValue();
		String targetRelvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME)).getString().trim();
		int triggeredOperationType = ((NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE)).getIntegerValue();
		boolean distinct = ((LogicalValue) getPresentationValue(ATTRIBUTENAMES.ISDISTINCT)).getValue();
		boolean bypassAssignmentConstraintsForTarget = ((LogicalValue) getPresentationValue(ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS)).getValue();
		String expression = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim();

		TriggeredDataAction triggeredDataAction = new TriggeredDataAction(actionName, relvarName, operationType, targetRelvarName, triggeredOperationType, distinct, bypassAssignmentConstraintsForTarget, expression);

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(triggeredDataAction.dbAddCommand(RELVARNAMES.TRIGGEREDDATAACTION)); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserData().getLocale(), "TriggeredDataActionsCreate.Text");  //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}
