package be.SIRAPRISE.webclient;

import java.util.HashSet;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.TriggeredDataAction;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class TriggeredDataActionsDelete extends TriggeredDataActionsWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * 
	 */
	private void processSelection ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
		AbstractRelation r = getSelectedActions(siraPriseServer);
		if (r.size() == 1) {
			try {
				TriggeredDataAction selectedAction = r.toObjectCollection(TriggeredDataAction.class).iterator().next();
				setPresentation("TriggeredDataActionsDeleteConfirm"); //$NON-NLS-1$
				setSiraPriseServerPortPresentationValues(siraPriseServer);
				setPresentationValue(ATTRIBUTENAMES.DATAACTIONNAME, selectedAction.getActionName());
				setPresentationValue(ATTRIBUTENAMES.RELVARNAME, selectedAction.getRelvarName());
				setPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE, selectedAction.getOperationType());
				setPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME, selectedAction.getTargetRelvarName());
				setPresentationValue(ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE, selectedAction.getTriggeredOperationType());
				setPresentationValue(ATTRIBUTENAMES.ISDISTINCT, selectedAction.isDistinct());
				setPresentationValue(ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS, selectedAction.isBypassAssignmentConstraints());
				setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, selectedAction.getExpression());

				saveInFunctionContext(RELVARNAMES.TRIGGEREDDATAACTION, selectedAction);
			} catch (ConstructorMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (SettersMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			}
		} else {
			setPresentationValue("TRIGGEREDDATAACTIONS", getWAARListValue("TRIGGEREDDATAACTIONS", r, new HashSet<String>())); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.DATAACTIONNAME) != null || getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME) != null) {
			processSelection();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TRIGGEREDDATAACTIONSSELECT)) {
			processSelection();
		} else {
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommand(((TriggeredDataAction) getFromFunctionContextMandatory(RELVARNAMES.TRIGGEREDDATAACTION)).dbDeleteCommand(RELVARNAMES.TRIGGEREDDATAACTION)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TRIGGEREDDATAACTIONSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserData().getLocale(), "TriggeredDataActionsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
