package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet; //import java.util.logging.Logger;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to produce an overview of database constraints
 * 
 * @author Erwin
 */
public class TriggeredDataActionsOverview extends TriggeredDataActionsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME) != null) {
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		// String expression;
		String triggeredDataActionsExpression = RELVARNAMES.TRIGGEREDDATAACTION;

		if (((LogicalValue) getPresentationValue("SELECTBYOPERATIONTYPE")).getValue()) { //$NON-NLS-1$
			NumberedEnumerationValue wv_operationType = (NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE);
			if (wv_operationType != null) {
				triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",EQ(" + ATTRIBUTENAMES.OPERATIONTYPE + ",INT(" + wv_operationType.getIntegerValue() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}
		}

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_relvarNamePattern = (GenericStringValue) getPresentationValue("RELVARNAMEPATTERN"); //$NON-NLS-1$
		if (wv_relvarName != null) {
			if (wv_relvarNamePattern != null) {
				throw new BothNameAndPatternNotAllowedException(getUserLocale());
			} else {
				triggeredDataActionsExpression = "SEMIJOIN(" + triggeredDataActionsExpression + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(wv_relvarName.getString()), ATTRIBUTENAMES.RELVARNAME, TYPENAMES.NAME) + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		} else {
			if (wv_relvarNamePattern != null) {
				triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + BracketParser.meta(wv_relvarNamePattern.getString().trim().toUpperCase()) + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
		}

		if (((LogicalValue) getPresentationValue("SELECTBYTRIGGEREDOPERATIONTYPE")).getValue()) { //$NON-NLS-1$
			NumberedEnumerationValue wv_triggeredOperationType = (NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE);
			if (wv_triggeredOperationType != null) {
				triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",EQ(" + ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE + ",INT(" + wv_triggeredOperationType.getIntegerValue() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}
		}

		GenericStringValue wv_targetRelvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME);
		GenericStringValue wv_targetRelvarNamePattern = (GenericStringValue) getPresentationValue("TARGETRELVARNAMEPATTERN"); //$NON-NLS-1$
		if (wv_targetRelvarName != null) {
			if (wv_targetRelvarNamePattern != null) {
				throw new BothNameAndPatternNotAllowedException(getUserLocale());
			} else {
				triggeredDataActionsExpression = "SEMIJOIN(" + triggeredDataActionsExpression + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(wv_targetRelvarName.getString()), ATTRIBUTENAMES.TARGETRELVARNAME, TYPENAMES.NAME) + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		} else {
			if (wv_targetRelvarNamePattern != null) {
				triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.TARGETRELVARNAME + "),STRING(" + BracketParser.meta(wv_targetRelvarNamePattern.getString().trim().toUpperCase()) + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
		}

		if (((LogicalValue) getPresentationValue("SELECTBYISDISTINCT")).getValue()) { //$NON-NLS-1$
			triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",EQ(" + ATTRIBUTENAMES.ISDISTINCT + ",BOOLEAN(" + ((LogicalValue) getPresentationValue(ATTRIBUTENAMES.ISDISTINCT)).getValue() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		}

		if (((LogicalValue) getPresentationValue("SELECTBYBYPASSASSGCONSTRAINTS")).getValue()) { //$NON-NLS-1$
			triggeredDataActionsExpression = "RESTRICT(" + triggeredDataActionsExpression + ",EQ(" + ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS + ",BOOLEAN(" + ((LogicalValue) getPresentationValue(ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS)).getValue() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("TRIGGEREDDATAACTIONSLIST", getWAARListValue("TRIGGEREDDATAACTIONSLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(triggeredDataActionsExpression), new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION, ATTRIBUTENAMES.CONSTRAINTLABEL })))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TriggeredDataActionsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}