/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 * 
 */
abstract class TriggeredDataActionsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String TRIGGEREDDATAACTIONSSELECT = "TriggeredDataActionsSelect"; //$NON-NLS-1$

	/**
	 * @param siraPriseServer
	 * @return
	 * @throws WaarException
	 */
	AbstractRelation getSelectedActions (SiraPriseServer siraPriseServer) throws WaarException {

		GenericStringValue wv_dataActionName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.DATAACTIONNAME);
		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_targetRelvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TARGETRELVARNAME);
		NumberedEnumerationValue wv_operationType = (NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE);
		NumberedEnumerationValue wv_triggeredOperationType = (NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE);
		LogicalValue wv_bypassAssgconstraints = (LogicalValue) getPresentationValue(ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS);
		LogicalValue wv_isDistinct = (LogicalValue) getPresentationValue(ATTRIBUTENAMES.ISDISTINCT);
		LogicalValue wv_selectByBypassAssgconstraints = (LogicalValue) getPresentationValue("SELECTBYBYPASSASSGCONSTRAINTS"); //$NON-NLS-1$
		LogicalValue wv_selectByIsDistinct = (LogicalValue) getPresentationValue("SELECTBYISDISTINCT"); //$NON-NLS-1$

		String restrictCondition = ""; //$NON-NLS-1$
		if (wv_dataActionName != null) {
			restrictCondition = "EQ(" + ATTRIBUTENAMES.DATAACTIONNAME + ",NAME(" + wv_dataActionName.getString() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
		}
		if (wv_relvarName != null) {
			String relvarNameCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + wv_relvarName.getString() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + relvarNameCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = relvarNameCondition;
			}
		}
		if (wv_targetRelvarName != null) {
			String targetRelvarCondition = "EQ(" + ATTRIBUTENAMES.TARGETRELVARNAME + ",NAME(" + wv_targetRelvarName.getString() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + targetRelvarCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = targetRelvarCondition;
			}
		}
		if (wv_operationType != null) {
			String operationTypeCondition = "EQ(" + ATTRIBUTENAMES.OPERATIONTYPE + ",INT(" + wv_operationType.getIntegerValue() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + operationTypeCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = operationTypeCondition;
			}
		}
		if (wv_triggeredOperationType != null) {
			String triggeredOperationTypeCondition = "EQ(" + ATTRIBUTENAMES.TRIGGEREDOPERATIONTYPE + ",INT(" + wv_triggeredOperationType.getIntegerValue() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + triggeredOperationTypeCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = triggeredOperationTypeCondition;
			}
		}
		if (wv_selectByIsDistinct.getValue()) {
			String isDistinctCondition = "EQ(" + ATTRIBUTENAMES.ISDISTINCT + ",BOOLEAN(" + wv_isDistinct.getValue() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + isDistinctCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = isDistinctCondition;
			}
		}
		if (wv_selectByBypassAssgconstraints.getValue()) {
			String bypassesAssignmentconstraintsForTargetCondition = "EQ(" + ATTRIBUTENAMES.BYPASSASSGCONSTRAINTS + ",BOOLEAN(" + wv_bypassAssgconstraints.getValue() + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + bypassesAssignmentconstraintsForTargetCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = bypassesAssignmentconstraintsForTargetCondition;
			}
		}

		if (restrictCondition.length() < 1) {
			throw new PleaseEnterSelectionCriterionException(getUserLocale());
		}

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			return dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.TRIGGEREDDATAACTION + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}
}
