package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.TupleConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class TupleConstraintsCreate extends TupleConstraintsWebClientFunction {

	/**
	 * leave the function or not after completion
	 */
	boolean leave = false;

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
			String constraintExpression = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim();
			long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();

			DmlAssignmentCommand[] cmds;
			GenericStringValue wv_constraintMessageText = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT));
			if (wv_constraintMessageText != null) {
				TupleConstraint tupleConstraint = new TupleConstraint(relvarName, errorCode, constraintExpression, wv_constraintMessageText.getString());
				cmds = new DmlAssignmentCommand[] { tupleConstraint.dbAddCommand(RELVARNAMES.TUPLECONSTRAINT), tupleConstraint.dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
			} else {
				cmds = new DmlAssignmentCommand[] { new TupleConstraint(relvarName, errorCode, constraintExpression, "").dbAddCommand(RELVARNAMES.TUPLECONSTRAINT) }; //$NON-NLS-1$
			}
			startTransaction.execMultipleStatementAndEndTransaction(cmds);
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TupleConstraintsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
