package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.TupleConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class TupleConstraintsDelete extends TupleConstraintsWebClientFunction {

	/**
	 * leave the function or not after completion
	 */
	boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedTupleConstraint ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_relvarNamePattern = (GenericStringValue) getPresentationValue("RELVARNAMEPATTERN"); //$NON-NLS-1$
		GenericLongValue wv_errorCode = (GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE);

		AbstractRelation r_constraints = getConstraints(wv_relvarNamePattern, wv_relvarName, wv_errorCode, siraPriseServer);

		Collection<TupleConstraint> constraints;
		try {
			constraints = r_constraints.toObjectCollection(TupleConstraint.class);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		}

		if (constraints.size() == 1) {
			TupleConstraint constraint = constraints.iterator().next();
			saveInFunctionContext(RELVARNAMES.TUPLECONSTRAINT, constraint);
			setPresentation("TupleConstraintsDeleteConfirm"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(siraPriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, wv_errorCode);
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, constraint.getConstraintExpression());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, constraint.getMessageText());
		} else {
			// display the list on the selection presentation
			setPresentationValue("CONSTRAINTS", getWAARListValue("CONSTRAINTS", r_constraints, new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION })))); //$NON-NLS-1$//$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue("RELVARNAMEPATTERN") != null || getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) { //$NON-NLS-1$
			processSelectedTupleConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TUPLECONSTRAINTSSELECT)) {
			// errorocde entered, ask confirmation
			processSelectedTupleConstraint();
		} else {
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
			
			DBConnection dbc = getDBConnection(siraPriseServer);
			try {
				DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

				TupleConstraint constraint = (TupleConstraint) getFromFunctionContextMandatory(RELVARNAMES.TUPLECONSTRAINT);
				DmlDeleteCommand cmd1 = constraint.dbDeleteCommand(RELVARNAMES.TUPLECONSTRAINT);
				DmlUnassertCommand cmd2 = constraint.dbUnAssertCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT);
				startTransaction.execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { cmd1, cmd2 });
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TUPLECONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TupleConstraintsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}