package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.TupleConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class TupleConstraintsManage extends TupleConstraintsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedConstraint ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		AbstractRelation r_constraints = getConstraints((GenericStringValue) getPresentationValue("RELVARNAMEPATTERN"), (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME), (GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE), siraPriseServer); //$NON-NLS-1$

		Collection<TupleConstraint> constraints;
		try {
			constraints = r_constraints.toObjectCollection(TupleConstraint.class);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		}

		if (constraints.size() == 1) {
			TupleConstraint constraint = constraints.iterator().next();
			saveInFunctionContext(RELVARNAMES.TUPLECONSTRAINT, constraint);
			setPresentation("TupleConstraintsManageDetails"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(siraPriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, constraint.getRelvarName());
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, constraint.getErrorCode());
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, constraint.getConstraintExpression());
			setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, constraint.getMessageText());
		} else {
			// display the list on the selection presentation
			setPresentationValue("CONSTRAINTS", getWAARListValue("CONSTRAINTS", r_constraints, new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION })))); //$NON-NLS-1$//$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue("RELVARNAMEPATTERN") != null || getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) { //$NON-NLS-1$
			processSelectedConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TUPLECONSTRAINTSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedConstraint();
		} else {
			// new tuple constraint details entered, update the catalog
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

			GenericStringValue wv_newConstraintMessageText = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT);
			String newConstraintMessageText = wv_newConstraintMessageText != null ? wv_newConstraintMessageText.getString().trim() : ""; //$NON-NLS-1$

			TupleConstraint tupleConstraint = (TupleConstraint) getFromFunctionContextMandatory(RELVARNAMES.TUPLECONSTRAINT);
			
			tupleConstraint.setRelvarName(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim());
			tupleConstraint.setErrorCode(((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger());
			tupleConstraint.setConstraintExpression(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim());
			tupleConstraint.setMessageText(newConstraintMessageText);
			try {
				DmlAssignmentCommand[] cmds = tupleConstraint.smartUpdateCommand();
				DBConnection dbc = getDBConnection(siraPriseServer);
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e1) {
				
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {
		// this means we'd have come back from 'delete this constraint', either after delete or after cancel.
		// but we do that with mode=xfer, so we won't come back here
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TUPLECONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TupleConstraintsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}