/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 * 
 */
abstract class TupleConstraintsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String TUPLECONSTRAINTSSELECT = "TupleConstraintsSelect"; //$NON-NLS-1$

	/**
	 * @param wv_relvarNamePattern
	 * @param wv_relvarName
	 * @param wv_errorCode
	 * @param siraPriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws ConstraintNotFoundException
	 * @throws WAARApplicationException
	 */
	final AbstractRelation getConstraints (GenericStringValue wv_relvarNamePattern, GenericStringValue wv_relvarName, GenericLongValue wv_errorCode, SiraPriseServer siraPriseServer) throws NoConnectionException, ConstraintNotFoundException, WAARApplicationException {
		String restrictCondition = ""; //$NON-NLS-1$
		if (wv_relvarNamePattern != null) {
			if (wv_relvarName != null || wv_errorCode != null) {
				throw new RelvarNamePatternAndRelvarNameMutuallyExclusiveException(getUserLocale());
			} else {
				restrictCondition = "MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + wv_relvarNamePattern.getString() + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		} else {
			if (wv_relvarName != null) {
				restrictCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + wv_relvarName.getString().trim() + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if (wv_errorCode != null) {
				String errorCodeCondition = "EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + wv_errorCode.getLonginteger() + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if (restrictCondition.length() > 0) {
					restrictCondition = "AND(" + restrictCondition + "," + errorCodeCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
				} else {
					restrictCondition = errorCodeCondition;
				}
			}
		}

		String queryExpression;
		if (restrictCondition.length() > 0) {
			queryExpression = "RESTRICT(" + RELVARNAMES.TUPLECONSTRAINT + "," + restrictCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
		} else {
			queryExpression = RELVARNAMES.TUPLECONSTRAINT;
		}
		queryExpression = "LEFTJOIN(" + queryExpression + "," + RELVARNAMES.CONSTRAINTMESSAGETEXT + "," + ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT + "(STRING()))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			AbstractRelation rsp = startTransaction.execQueryAndEndTransaction(queryExpression);

			// check if the combination exists and display the constraintexpression if it does, else give a message
			if (rsp.size() < 1) {
				throw new ConstraintNotFoundException((wv_errorCode == null ? 0 : wv_errorCode.getLonginteger()), (wv_relvarName == null ? "" : wv_relvarName.getString()), getUserLocale()); //$NON-NLS-1$
			}

			return rsp;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}
}
