package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.jsba.JavaBackedType;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a base type
 * 
 * @author Erwin
 */
public class TypesDelete extends JavaTypesWebClientFunction {

	/**
	 * Leave the function after exit or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedTypeName ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
		JavaBackedType type = getType(siraPriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString());
		setPresentation("TypesDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, type.getName());
		saveInFunctionContext(RELVARNAMES.JAVABACKEDTYPE, type);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null) {
			processSelectedTypeName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(TYPESSELECT)) {
			// typename entered, ask confirmation
			processSelectedTypeName();
		} else {
			// confirmation entered, delete file and storage spaces
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
			DBConnection dbc = getDBConnection(siraPriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbDeleteAndEndTransaction(RELVARNAMES.JAVABACKEDTYPE, (JavaBackedType) getFromFunctionContextMandatory(RELVARNAMES.JAVABACKEDTYPE));  //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return TYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TypesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
