package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.*;

/**
 * Function to display an overview of defined types
 * 
 * @author Erwin
 */
public class TypesOverview extends JavaTypesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue namePattern = (GenericStringValue) getPresentationValue("NAMEPATTERN"); //$NON-NLS-1$
		String baseExpression;
		String baseExpressionConstrainedType;
		String baseExpressionUDTType = "LEFTJOIN(LEFTJOIN(" + RELVARNAMES.USERDEFINEDTYPE + ",RENAME(" + RELVARNAMES.UDTORDERINGOPERATOR + ",(SP_EXPRESSION,ORDERINGOPERATOREXPRESSION)),(ORDERINGOPERATOREXPRESSION(STRING()))),GROUP(UDTPHYSICALPOSSREPCOMPONENT,COMPONENTS(COMPONENTNAME,COMPONENTTYPENAME,LOGICALLENGTH,ORDINAL)),COMPONENTS(RELATION(HEADING(COMPONENTNAME(NAME)COMPONENTTYPENAME(NAME)LOGICALLENGTH(INT)ORDINAL(INT))BODY())))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
		if (namePattern != null) {
			String namePatternMeta = BracketParser.meta(namePattern.getString());
			baseExpression = "RESTRICT(" + RELVARNAMES.TYPEPROPERTIES + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.TYPENAME + "),STRING(" + namePatternMeta + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			baseExpressionConstrainedType = "RESTRICT(" + RELVARNAMES.CONSTRAINEDTYPE + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.TYPENAME + "),STRING(" + namePatternMeta + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			baseExpressionUDTType = "RESTRICT(" + baseExpressionUDTType + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.TYPENAME + "),STRING(" + namePatternMeta + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		} else {
			baseExpression = RELVARNAMES.TYPEPROPERTIES;
			baseExpressionConstrainedType = RELVARNAMES.CONSTRAINEDTYPE;
		}

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			setPresentationValue("TYPELIST", getWAARListValue("TYPELIST", startTransaction.execQuery("SEMIMINUS(" + baseExpression + ",RENAME(PROJECT(" + RELVARNAMES.INTERVALTYPE + ",(" + ATTRIBUTENAMES.INTERVALTYPENAME + ")),(" + ATTRIBUTENAMES.INTERVALTYPENAME + "," + ATTRIBUTENAMES.TYPENAME + ")))"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			setPresentationValue("INTERVALTYPELIST", getWAARListValue("INTERVALTYPELIST", startTransaction.execQuery("JOIN(" + baseExpression + ",RENAME(PROJECT(" + RELVARNAMES.INTERVALTYPE + ",(" + ATTRIBUTENAMES.INTERVALTYPENAME + ")),(" + ATTRIBUTENAMES.INTERVALTYPENAME + "," + ATTRIBUTENAMES.TYPENAME + ")))"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			setPresentationValue("CONSTRAINEDTYPELIST", getWAARListValue("CONSTRAINEDTYPELIST", startTransaction.execQuery("JOIN(RENAME(" + RELVARNAMES.TYPEPROPERTIES + ",(" + ATTRIBUTENAMES.TYPENAME + "," + ATTRIBUTENAMES.BASETYPE + "))," + baseExpressionConstrainedType + ")"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			setPresentationValue("USERDEFINEDTYPELIST", getWAARListValue("USERDEFINEDTYPELIST", startTransaction.execQueryAndEndTransaction(baseExpressionUDTType), new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION, "ORDERINGOPERATOREXPRESSION" })))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "TypesOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}