/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
public final class UserDefinedOrderingOperator extends AbstractUpdatableDBObject implements UdtorderingoperatorToDBObject, DBObjectToUdtorderingoperator {

	/**
	 * The expression defining the order of members of the type this expression applies to. The parameters in this expression are named 'V1' and 'V2', respectively, and must be referenced as 'PARAMETER(Vn(typename))'.
	 */
	private String expression;

	/**
	 * 
	 */
	private UserDefinedOrderingOperator preUpdateState;

	/**
	 * The name of the user-defined type whose ordering is defined by the expression held in this object
	 */
	private String typeName;

	/**
	 * Creates the UserDefinedOrderingOperator
	 */
	public UserDefinedOrderingOperator ( ) {
		this.typeName = ""; //$NON-NLS-1$
		this.expression = ""; //$NON-NLS-1$
	}

	/**
	 * Creates the UserDefinedOrderingOperator
	 * 
	 * @param typeName
	 *            The name of the user-defined type whose ordering is defined by the expression held in this object
	 * @param expression
	 *            The expression defining the order of members of the type this expression applies to. The parameters in this expression are named 'V1' and 'V2', respectively, and must be referenced as 'PARAMETER(Vn(typename))'.
	 */
	public UserDefinedOrderingOperator (String typeName, String expression) {
		this.typeName = typeName.toUpperCase();
		this.expression = expression;
	}

	/**
	 * Gets expression
	 *
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets typeName
	 *
	 * @return typeName.
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtorderingoperator#getUdtorderingoperatorSp_expression()
	 */
	public String getUdtorderingoperatorSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtorderingoperator#getUdtorderingoperatorTypename()
	 */
	public String getUdtorderingoperatorTypename ( ) {
		return typeName;
	}

	/**
	 * Sets expression
	 *
	 * @param expression The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new UserDefinedOrderingOperator(typeName, expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtorderingoperatorToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		this.expression = BracketParser.unMetaWithoutException(sp_expression);
	}

	/**
	 * Sets typeName
	 *
	 * @param typeName The typeName to set.
	 */
	public final void setTypeName (String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtorderingoperatorToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public void setTypenameFromDB (String typename) {
		this.typeName = typename.toUpperCase();
	}

}
