/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
public final class UserDefinedType extends AbstractUpdatableDBObject implements DBObjectToUserdefinedtype, DBObjectToUdtorderingoperator, UdtorderingoperatorToDBObject, UserdefinedtypeToDBObject {

	/**
	 * The expression defining the possrep constraint
	 */
	private String constraintExpression;

	/**
	 * The expression defining the ordering operator of the user-defined type; null and/or the empty string and/or all-blank strings indicate user-defined types without an ordering operator.
	 */
	private String orderingOperatorExpression;

	/**
	 * The name of the possrep that will be the physical possrep
	 */
	private String physicalPossrepName;

	/**
	 * 
	 */
	private UserDefinedType preUpdateState;

	/**
	 * The name of the user-defined type
	 */
	private String typeName;

	/**
	 * Creates the UserDefinedType
	 */
	public UserDefinedType () {
		this.typeName = ""; //$NON-NLS-1$
		this.physicalPossrepName = ""; //$NON-NLS-1$
		this.constraintExpression = ""; //$NON-NLS-1$
		this.orderingOperatorExpression = null;
	}

	/**
	 * Creates the UserDefinedType
	 * 
	 * @param typeName
	 * @param physicalPossrepName
	 * @param constraintExpression
	 * @param orderingOperatorExpression
	 */
	public UserDefinedType (String typeName, String physicalPossrepName, String constraintExpression, String orderingOperatorExpression) {
		this.typeName = typeName;
		this.physicalPossrepName = physicalPossrepName;
		this.constraintExpression = constraintExpression;
		this.orderingOperatorExpression = orderingOperatorExpression;
	}

	/**
	 * Gets constraintExpression
	 *
	 * @return constraintExpression.
	 */
	public final String getConstraintExpression ( ) {
		return constraintExpression;
	}

	/**
	 * Gets orderingOperatorExpression
	 *
	 * @return orderingOperatorExpression.
	 */
	public final String getOrderingOperatorExpression ( ) {
		return orderingOperatorExpression;
	}

	/**
	 * Gets physicalPossrepName
	 *
	 * @return physicalPossrepName.
	 */
	public final String getPhysicalPossrepName ( ) {
		return physicalPossrepName;
	}

	/**
	 * Gets typeName
	 *
	 * @return typeName.
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/**
	 * Sets constraintExpression
	 *
	 * @param constraintExpression The constraintExpression to set.
	 */
	public final void setConstraintExpression (String constraintExpression) {
		this.constraintExpression = constraintExpression;
	}

	/**
	 * Sets orderingOperatorExpression
	 *
	 * @param orderingOperatorExpression The orderingOperatorExpression to set.
	 */
	public final void setOrderingOperatorExpression (String orderingOperatorExpression) {
		this.orderingOperatorExpression = orderingOperatorExpression;
	}

	/**
	 * Sets physicalPossrepName
	 *
	 * @param physicalPossrepName The physicalPossrepName to set.
	 */
	public final void setPhysicalPossrepName (String physicalPossrepName) {
		this.physicalPossrepName = physicalPossrepName.toUpperCase();
	}

	/**
	 * Sets typeName
	 *
	 * @param typeName The typeName to set.
	 */
	public final void setTypeName (String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtorderingoperator#getUdtorderingoperatorSp_expression()
	 */
	public final String getUdtorderingoperatorSp_expression ( ) {
		return BracketParser.meta(orderingOperatorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtorderingoperator#getUdtorderingoperatorTypename()
	 */
	public final String getUdtorderingoperatorTypename ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUserdefinedtype#getUserdefinedtypePossrepname()
	 */
	public final String getUserdefinedtypePossrepname ( ) {
		return physicalPossrepName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUserdefinedtype#getUserdefinedtypeSp_expression()
	 */
	public final String getUserdefinedtypeSp_expression ( ) {
		return BracketParser.meta(constraintExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUserdefinedtype#getUserdefinedtypeTypename()
	 */
	public final String getUserdefinedtypeTypename ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UserdefinedtypeToDBObject#setPossrepnameFromDB(java.lang.String)
	 */
	public final void setPossrepnameFromDB (String possrepname) {
		this.physicalPossrepName = possrepname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		this.preUpdateState = new UserDefinedType(typeName, physicalPossrepName, constraintExpression, orderingOperatorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtorderingoperatorToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public final void setSp_expressionFromDB (String sp_expression) {
		try {
			this.constraintExpression = BracketParser.unMeta(sp_expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtorderingoperatorToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public final void setTypenameFromDB (String typename) {
		this.typeName = typename.toUpperCase();
	}

}
