/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
public final class UserDefinedTypePPCValueSelector extends AbstractUpdatableDBObject implements DBObjectToUdtppcvalueselector, UdtppcvalueselectorToDBObject {

	/**
	 * 
	 */
	private String possrepName;

	/**
	 * 
	 */
	private String ppcComponentName;

	/**
	 * 
	 */
	private String ppcComponentValueSelectorExpression;

	/**
	 * 
	 */
	private UserDefinedTypePPCValueSelector preUpdateState;

	/**
	 * 
	 */
	private String typeName;

	/**
	 * Creates the UserDefinedTypePPCValueSelector
	 */
	public UserDefinedTypePPCValueSelector ( ) {
		this.typeName = ""; //$NON-NLS-1$
		this.possrepName = ""; //$NON-NLS-1$
		this.ppcComponentName = ""; //$NON-NLS-1$
		this.ppcComponentValueSelectorExpression = ""; //$NON-NLS-1$
	}

	/**
	 * Creates the UserDefinedTypePPCValueSelector
	 * 
	 * @param typeName
	 * @param possrepName
	 * @param ppcComponentName
	 * @param ppcComponentValueSelectorExpression
	 */
	public UserDefinedTypePPCValueSelector (String typeName, String possrepName, String ppcComponentName, String ppcComponentValueSelectorExpression) {
		this.typeName = typeName.toUpperCase();
		this.possrepName = possrepName.toUpperCase();
		this.ppcComponentName = ppcComponentName.toUpperCase();
		this.ppcComponentValueSelectorExpression = ppcComponentValueSelectorExpression;
	}

	/**
	 * Gets possrepName
	 * 
	 * @return possrepName.
	 */
	public final String getPossrepName ( ) {
		return possrepName;
	}

	/**
	 * Gets ppcComponentName
	 * 
	 * @return ppcComponentName.
	 */
	public final String getPpcComponentName ( ) {
		return ppcComponentName;
	}

	/**
	 * Gets ppcComponentValueSelectorExpression
	 * 
	 * @return ppcComponentValueSelectorExpression.
	 */
	public final String getPpcComponentValueSelectorExpression ( ) {
		return ppcComponentValueSelectorExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets typeName
	 * 
	 * @return typeName.
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtppcvalueselector#getUdtppcvalueselectorComponentname()
	 */
	public String getUdtppcvalueselectorComponentname ( ) {
		return ppcComponentName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtppcvalueselector#getUdtppcvalueselectorPossrepname()
	 */
	public String getUdtppcvalueselectorPossrepname ( ) {
		return possrepName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtppcvalueselector#getUdtppcvalueselectorSp_expression()
	 */
	public String getUdtppcvalueselectorSp_expression ( ) {
		return BracketParser.meta(ppcComponentValueSelectorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtppcvalueselector#getUdtppcvalueselectorTypename()
	 */
	public String getUdtppcvalueselectorTypename ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtppcvalueselectorToDBObject#setComponentnameFromDB(java.lang.String)
	 */
	public void setComponentnameFromDB (String componentname) {
		this.ppcComponentName = componentname.toUpperCase();
	}

	/**
	 * Sets possrepName
	 * 
	 * @param possrepName
	 *            The possrepName to set.
	 */
	public final void setPossrepName (String possrepName) {
		this.possrepName = possrepName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtppcvalueselectorToDBObject#setPossrepnameFromDB(java.lang.String)
	 */
	public void setPossrepnameFromDB (String possrepname) {
		this.possrepName = possrepname.toUpperCase();
	}

	/**
	 * Sets ppcComponentName
	 * 
	 * @param ppcComponentName
	 *            The ppcComponentName to set.
	 */
	public final void setPpcComponentName (String ppcComponentName) {
		this.ppcComponentName = ppcComponentName.toUpperCase();
	}

	/**
	 * Sets ppcComponentValueSelectorExpression
	 * 
	 * @param ppcComponentValueSelectorExpression
	 *            The ppcComponentValueSelectorExpression to set.
	 */
	public final void setPpcComponentValueSelectorExpression (String ppcComponentValueSelectorExpression) {
		this.ppcComponentValueSelectorExpression = ppcComponentValueSelectorExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		this.preUpdateState = new UserDefinedTypePPCValueSelector(typeName, possrepName, ppcComponentName, ppcComponentValueSelectorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtppcvalueselectorToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		this.ppcComponentValueSelectorExpression = BracketParser.unMetaWithoutException(sp_expression);
	}

	/**
	 * Sets typeName
	 * 
	 * @param typeName
	 *            The typeName to set.
	 */
	public final void setTypeName (String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtppcvalueselectorToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public void setTypenameFromDB (String typename) {
		this.typeName = typename.toUpperCase();
	}

}
