/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;

/**
 * @author Erwin
 * 
 */
public final class UserDefinedTypePhysicalPossrepComponent extends AbstractUpdatableDBObject implements DBObjectToUdtphysicalpossrepcomponent, UdtphysicalpossrepcomponentToDBObject {

	/**
	 * The component name
	 */
	private String componentName;

	/**
	 * The typename of the component's type
	 */
	private String componentTypeName;

	/**
	 * The logical Length of the component if its type is a variable-length one
	 */
	private int logicalLength;

	/**
	 * The ordinal position of the encoding of the component value in the total encoding of the user-defined type's value
	 */
	private int ordinal;

	/**
	 * 
	 */
	private UserDefinedTypePhysicalPossrepComponent preUpdateState;

	/**
	 * The name of the user-defined type to which this component belongs
	 */
	private String typeName;

	/**
	 * Creates the UserDefinedTypePhysicalPossrepComponent
	 */
	public UserDefinedTypePhysicalPossrepComponent () {
		this.typeName = ""; //$NON-NLS-1$
		this.componentName = ""; //$NON-NLS-1$
		this.componentTypeName = ""; //$NON-NLS-1$
		this.logicalLength = -1;
		this.ordinal = -1;
	}

	/**
	 * Creates the UserDefinedTypePhysicalPossrepComponent
	 *
	 * @param typeName
	 * @param componentName
	 * @param componentTypeName
	 * @param logicalLength
	 * @param ordinal
	 */
	public UserDefinedTypePhysicalPossrepComponent (String typeName, String componentName, String componentTypeName, int logicalLength, int ordinal) {
		this.typeName = typeName.toUpperCase();
		this.componentName = componentName.toUpperCase();
		this.componentTypeName = componentTypeName.toUpperCase();
		this.logicalLength = logicalLength;
		this.ordinal = ordinal;
	}

	/**
	 * Gets componentName
	 *
	 * @return componentName.
	 */
	public final String getComponentName ( ) {
		return componentName;
	}

	/**
	 * Gets componentTypeName
	 *
	 * @return componentTypeName.
	 */
	public final String getComponentTypeName ( ) {
		return componentTypeName;
	}

	/**
	 * Gets logicalLength
	 *
	 * @return logicalLength.
	 */
	public final int getLogicalLength ( ) {
		return logicalLength;
	}

	/**
	 * Gets ordinal
	 *
	 * @return ordinal.
	 */
	public final int getOrdinal ( ) {
		return ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets typeName
	 *
	 * @return typeName.
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtphysicalpossrepcomponent#getUdtphysicalpossrepcomponentComponentname()
	 */
	public String getUdtphysicalpossrepcomponentComponentname ( ) {
		return componentName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtphysicalpossrepcomponent#getUdtphysicalpossrepcomponentComponenttypename()
	 */
	public String getUdtphysicalpossrepcomponentComponenttypename ( ) {
		return componentTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtphysicalpossrepcomponent#getUdtphysicalpossrepcomponentLogicallength()
	 */
	public String getUdtphysicalpossrepcomponentLogicallength ( ) {
		return Integer.toString(logicalLength);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtphysicalpossrepcomponent#getUdtphysicalpossrepcomponentOrdinal()
	 */
	public String getUdtphysicalpossrepcomponentOrdinal ( ) {
		return Integer.toString(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtphysicalpossrepcomponent#getUdtphysicalpossrepcomponentTypename()
	 */
	public String getUdtphysicalpossrepcomponentTypename ( ) {
		return typeName;
	}

	/**
	 * Sets componentName
	 *
	 * @param componentName The componentName to set.
	 */
	public final void setComponentName (String componentName) {
		this.componentName = componentName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtphysicalpossrepcomponentToDBObject#setComponentnameFromDB(java.lang.String)
	 */
	public void setComponentnameFromDB (String componentname) {
		this.componentName = componentname.toUpperCase();
	}

	/**
	 * Sets componentTypeName
	 *
	 * @param componentTypeName The componentTypeName to set.
	 */
	public final void setComponentTypeName (String componentTypeName) {
		this.componentTypeName = componentTypeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtphysicalpossrepcomponentToDBObject#setComponenttypenameFromDB(java.lang.String)
	 */
	public void setComponenttypenameFromDB (String componenttypename) {
		this.componentTypeName = componenttypename.toUpperCase();
	}

	/**
	 * Sets logicalLength
	 *
	 * @param logicalLength The logicalLength to set.
	 */
	public final void setLogicalLength (int logicalLength) {
		this.logicalLength = logicalLength;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtphysicalpossrepcomponentToDBObject#setLogicallengthFromDB(java.lang.String)
	 */
	public void setLogicallengthFromDB (String logicallength) {
		this.logicalLength = Integer.parseInt(logicallength);
	}

	/**
	 * Sets ordinal
	 *
	 * @param ordinal The ordinal to set.
	 */
	public final void setOrdinal (int ordinal) {
		this.ordinal = ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtphysicalpossrepcomponentToDBObject#setOrdinalFromDB(java.lang.String)
	 */
	public void setOrdinalFromDB (String ordinal) {
		this.ordinal = Integer.parseInt(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		this.preUpdateState = new UserDefinedTypePhysicalPossrepComponent(typeName, componentName, componentTypeName, logicalLength, ordinal);
	}

	/**
	 * Sets typeName
	 *
	 * @param typeName The typeName to set.
	 */
	public final void setTypeName (String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtphysicalpossrepcomponentToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public void setTypenameFromDB (String typename) {
		this.typeName = typename.toUpperCase();
	}

}
