/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
public final class UserDefinedTypePossrepComponent extends AbstractUpdatableDBObject implements UdtpossrepcomponentToDBObject, DBObjectToUdtpossrepcomponent {

	/**
	 * 
	 */
	private String componentName;

	/**
	 * 
	 */
	private String componentValueSelectorExpression;

	/**
	 * 
	 */
	private String possrepName;

	/**
	 * 
	 */
	private UserDefinedTypePossrepComponent preUpdateState;

	/**
	 * 
	 */
	private String typeName;

	/**
	 * Creates the UserDefinedTypePossrepComponent
	 */
	public UserDefinedTypePossrepComponent () {
		this.typeName = ""; //$NON-NLS-1$
		this.possrepName = ""; //$NON-NLS-1$
		this.componentName = ""; //$NON-NLS-1$
		this.componentValueSelectorExpression = ""; //$NON-NLS-1$
	}

	/**
	 * Creates the UserDefinedTypePossrepComponent
	 * 
	 * @param typeName
	 * @param possrepName
	 * @param componentName
	 * @param componentValueSelectorExpression
	 */
	public UserDefinedTypePossrepComponent (String typeName, String possrepName, String componentName, String componentValueSelectorExpression) {
		this.typeName = typeName.toUpperCase();
		this.possrepName = possrepName.toUpperCase();
		this.componentName = componentName.toUpperCase();
		this.componentValueSelectorExpression = componentValueSelectorExpression;
	}

	/**
	 * Gets componentName
	 *
	 * @return componentName.
	 */
	public final String getComponentName ( ) {
		return componentName;
	}

	/**
	 * Gets componentValueSelectorExpression
	 *
	 * @return componentValueSelectorExpression.
	 */
	public final String getComponentValueSelectorExpression ( ) {
		return componentValueSelectorExpression;
	}

	/**
	 * Gets possrepName
	 *
	 * @return possrepName.
	 */
	public final String getPossrepName ( ) {
		return possrepName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets typeName
	 *
	 * @return typeName.
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtpossrepcomponent#getUdtpossrepcomponentComponentname()
	 */
	public String getUdtpossrepcomponentComponentname ( ) {
		return componentName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtpossrepcomponent#getUdtpossrepcomponentPossrepname()
	 */
	public String getUdtpossrepcomponentPossrepname ( ) {
		return possrepName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtpossrepcomponent#getUdtpossrepcomponentSp_expression()
	 */
	public String getUdtpossrepcomponentSp_expression ( ) {
		return BracketParser.meta(componentValueSelectorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToUdtpossrepcomponent#getUdtpossrepcomponentTypename()
	 */
	public String getUdtpossrepcomponentTypename ( ) {
		return typeName;
	}

	/**
	 * Sets componentName
	 *
	 * @param componentName The componentName to set.
	 */
	public final void setComponentName (String componentName) {
		this.componentName = componentName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtpossrepcomponentToDBObject#setComponentnameFromDB(java.lang.String)
	 */
	public void setComponentnameFromDB (String componentname) {
		this.componentName = componentname.toUpperCase();
	}

	/**
	 * Sets componentValueSelectorExpression
	 *
	 * @param componentValueSelectorExpression The componentValueSelectorExpression to set.
	 */
	public final void setComponentValueSelectorExpression (String componentValueSelectorExpression) {
		this.componentValueSelectorExpression = componentValueSelectorExpression;
	}

	/**
	 * Sets possrepName
	 *
	 * @param possrepName The possrepName to set.
	 */
	public final void setPossrepName (String possrepName) {
		this.possrepName = possrepName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtpossrepcomponentToDBObject#setPossrepnameFromDB(java.lang.String)
	 */
	public void setPossrepnameFromDB (String possrepname) {
		this.possrepName = possrepname.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		this.preUpdateState = new UserDefinedTypePossrepComponent(typeName, possrepName, componentName, componentValueSelectorExpression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtpossrepcomponentToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		this.componentValueSelectorExpression = BracketParser.unMetaWithoutException(sp_expression);
	}

	/**
	 * Sets typeName
	 *
	 * @param typeName The typeName to set.
	 */
	public final void setTypeName (String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.UdtpossrepcomponentToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public void setTypenameFromDB (String typename) {
		this.typeName = typename.toUpperCase();
	}

}
