package be.SIRAPRISE.webclient;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a user-defined type.
 * 
 * @author Erwin
 */
public class UserDefinedTypesCreate extends UserDefinedTypesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String typeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();
		String possrepName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME)).getString().trim();
		GenericStringValue wv_possrepComponentNames = (GenericStringValue) getPresentationValue("POSSREPCOMPONENTNAMES"); //$NON-NLS-1$
		Set<String> possrepComponentNames = RelationValueSelectorFactory.getNamesInEntryOrderWithoutDuplicates(wv_possrepComponentNames == null ? "" : wv_possrepComponentNames.getString().trim()); //$NON-NLS-1$
		GenericStringValue wv_possrepComponentTypeNames = (GenericStringValue) getPresentationValue("POSSREPCOMPONENTTYPENAMES"); //$NON-NLS-1$
		LinkedList<String> possrepComponentTypeNames = RelationValueSelectorFactory.getNamesInEntryOrder(wv_possrepComponentTypeNames == null ? "" : wv_possrepComponentTypeNames.getString().trim()); //$NON-NLS-1$
		GenericStringValue wv_constraintExpression = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION);
		String constraintExpression = wv_constraintExpression == null ? "" : wv_constraintExpression.getString().trim(); //$NON-NLS-1$
		GenericStringValue wv_orderingOperatorExpression = (GenericStringValue) getPresentationValue("ORDERINGOPERATOREXPRESSION"); //$NON-NLS-1$
		String orderingOperatorExpression = wv_orderingOperatorExpression == null ? "" : wv_orderingOperatorExpression.getString().trim(); //$NON-NLS-1$

		if (possrepComponentNames.size() != possrepComponentTypeNames.size()) {
			throw new UnEqualNumberOfComponentNamesAndComponentTypeNamesException(possrepComponentNames, possrepComponentTypeNames, getUserLocale());
		}

		Set<DmlAddCommand> cmds = new HashSet<DmlAddCommand>();

		int ordinal = 0;
		Iterator<String> i_possrepComponentNames = possrepComponentNames.iterator();
		Iterator<String> i_possrepComponentTypeNames = possrepComponentTypeNames.iterator();
		while (i_possrepComponentNames.hasNext()) {
			String possrepComponentName = i_possrepComponentNames.next();
			String possrepComponentTypeSpec = i_possrepComponentTypeNames.next();
			int possrepComponentTypeLogicalLength;
			String possrepComponentTypeName;
			try {
				NameValuePair nvr = BracketParser.getNameAndMandatoryValueFromNonEscaped(possrepComponentTypeSpec, 0).getNameValuePair();
				possrepComponentTypeName = nvr.getName();
				possrepComponentTypeLogicalLength = Integer.parseInt(nvr.getValue());
			} catch (NoClosingBracketException e) {
				throw new ExpectedBracketsMissingException(possrepComponentTypeSpec, getUserLocale());
			} catch (NoOpeningBracketException e) {
				possrepComponentTypeName = possrepComponentTypeSpec;
				possrepComponentTypeLogicalLength = 0;
			}
			cmds.add(new UDTPhysicalPossrepComponent(typeName, possrepComponentName, possrepComponentTypeName, possrepComponentTypeLogicalLength, (ordinal += 10)).dbAddCommand(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT));
		}

		UserDefinedType userDefinedType = new UserDefinedType(typeName, possrepName, constraintExpression, orderingOperatorExpression);
		cmds.add(userDefinedType.dbAddCommand(RELVARNAMES.USERDEFINEDTYPE));

		if (orderingOperatorExpression.length() > 0) {
			cmds.add(userDefinedType.dbAddCommand(RELVARNAMES.UDTORDERINGOPERATOR));
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}
