package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a user-defined type definition
 * 
 * @author Erwin
 */
public class UserDefinedTypesDelete extends UserDefinedTypesWebClientFunction {

	/**
	 * 
	 */
	private static final String COMMANDS = "COMMANDS"; //$NON-NLS-1$

	/**
	 * Flag telling whether the function can be left or not
	 */
	private boolean leave = false;

	/**
	 * Queries the catalog for the selected type and displays the delete confirm presentation
	 * 
	 * @throws WaarException
	 */
	private void processSelectedType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		WaarValue wv_typeName = getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		String typeName = ((GenericStringValue) wv_typeName).getString().trim();

		// Get the basetypename and the constraintexpression to save it in the sessioncontext
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String typeNameCondition = "EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			AbstractRelation r_userDefinedType = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.USERDEFINEDTYPE + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (r_userDefinedType.size() < 1) {
				throw new UserDefinedTypeNotFoundException(typeName, getUserLocale());
			}
			AbstractRelation r_userDefinedOrderingOperator = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTORDERINGOPERATOR + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_userDefinedTypePhysicalPossrepComponents = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_userDefinedTypeNonPhysicalPossreps = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPOSSREP + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_userDefinedTypeNonPhysicalPossrepComponents = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPOSSREPCOMPONENT + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_userDefinedTypePPCValueSelectors = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.UDTPPCVALUESELECTOR + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			Set<DmlAssignmentCommand> dmlDeleteCommands = new HashSet<DmlAssignmentCommand>();

			dmlDeleteCommands.add(DBObjectFactory.getObject(r_userDefinedType.iterator().next(), UserDefinedType.class).dbDeleteCommand(RELVARNAMES.USERDEFINEDTYPE));

			// The deletecommand for the ordering operator, if there is one
			Collection<UserDefinedOrderingOperator> userDefinedOrderingOperators = r_userDefinedOrderingOperator.toObjectCollection(UserDefinedOrderingOperator.class);
			for (UserDefinedOrderingOperator userDefinedOrderingOperator : userDefinedOrderingOperators) {
				dmlDeleteCommands.add(userDefinedOrderingOperator.dbDeleteCommand(RELVARNAMES.UDTORDERINGOPERATOR));
			}

			// The deletecommand for the physical possrep components, if there are any
			Collection<UserDefinedTypePhysicalPossrepComponent> userDefinedTypePhysicalPossrepComponents = r_userDefinedTypePhysicalPossrepComponents.toObjectCollection(UserDefinedTypePhysicalPossrepComponent.class);
			for (UserDefinedTypePhysicalPossrepComponent userDefinedTypePhysicalPossrepComponent : userDefinedTypePhysicalPossrepComponents) {
				dmlDeleteCommands.add(userDefinedTypePhysicalPossrepComponent.dbDeleteCommand(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT));
			}

			// The deletecommand for the ordering operator, if there is one
			Collection<UserDefinedTypeNonPhysicalPossrep> userDefinedTypeNonPhysicalPossreps = r_userDefinedTypeNonPhysicalPossreps.toObjectCollection(UserDefinedTypeNonPhysicalPossrep.class);
			for (UserDefinedTypeNonPhysicalPossrep userDefinedTypeNonPhysicalPossrep : userDefinedTypeNonPhysicalPossreps) {
				dmlDeleteCommands.add(userDefinedTypeNonPhysicalPossrep.dbDeleteCommand(RELVARNAMES.UDTPOSSREP));
			}

			// The deletecommand for the ordering operator, if there is one
			Collection<UserDefinedTypePossrepComponent> userDefinedTypePossrepComponents = r_userDefinedTypeNonPhysicalPossrepComponents.toObjectCollection(UserDefinedTypePossrepComponent.class);
			for (UserDefinedTypePossrepComponent userDefinedTypePossrepComponent : userDefinedTypePossrepComponents) {
				dmlDeleteCommands.add(userDefinedTypePossrepComponent.dbDeleteCommand(RELVARNAMES.UDTPOSSREPCOMPONENT));
			}

			// The deletecommand for the ordering operator, if there is one
			Collection<UserDefinedTypePPCValueSelector> userDefinedTypePPCValueSelectors = r_userDefinedTypePPCValueSelectors.toObjectCollection(UserDefinedTypePPCValueSelector.class);
			for (UserDefinedTypePPCValueSelector userDefinedTypePPCValueSelector : userDefinedTypePPCValueSelectors) {
				dmlDeleteCommands.add(userDefinedTypePPCValueSelector.dbDeleteCommand(RELVARNAMES.UDTORDERINGOPERATOR));
			}

			setPresentation("UserDefinedTypesDeleteConfirm"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);

			saveInFunctionContext(ATTRIBUTENAMES.TYPENAME, wv_typeName);
			saveInFunctionContext(COMMANDS, dmlDeleteCommands);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null) {
			processSelectedType();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	@SuppressWarnings("unchecked")
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(USERDEFINEDTYPESSELECT)) {
			// filename entered, ask confirmation
			processSelectedType();
		} else {
			// confirmation entered, delete type
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			setPresentationValue(ATTRIBUTENAMES.TYPENAME, (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.TYPENAME));

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction((Set<DmlAssignmentCommand>) getFromFunctionContextMandatory(COMMANDS)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return USERDEFINEDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}