package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a user-defined type definition
 * 
 * @author Erwin
 */
public class UserDefinedTypesManage extends UserDefinedTypesWebClientFunction {

	/**
	 * Flag telling whether the function can be left or not
	 */
	private boolean leave = false;

	/**
	 * Queries the catalog for the selected type and displays the delete confirm presentation
	 * 
	 * @throws WaarException
	 */
	private void processSelectedType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		WaarValue wv_typeName = getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		String typeName = ((GenericStringValue) wv_typeName).getString().trim();

		// Get the basetypename and the constraintexpression to save it in the sessioncontext
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String typeNameCondition = "EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			AbstractRelation r_userDefinedType = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.USERDEFINEDTYPE + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (r_userDefinedType.size() < 1) {
				throw new UserDefinedTypeNotFoundException(typeName, getUserLocale());
			}
			AbstractRelation r_userDefinedOrderingOperator = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTORDERINGOPERATOR + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_userDefinedTypePhysicalPossrepComponents = startTransaction.execQuery("JOIN(RESTRICT(" + RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT + "," + typeNameCondition + "),UNION(TRANSFORM(" + RELVARNAMES.JAVABACKEDTYPE + ",(" + ATTRIBUTENAMES.COMPONENTTYPENAME + "(TYPENAME),TYPESMANAGEFUNCTION(STRING(Types)))),TRANSFORM(" + RELVARNAMES.CONSTRAINEDTYPE + ",(" + ATTRIBUTENAMES.COMPONENTTYPENAME + "(TYPENAME),TYPESMANAGEFUNCTION(STRING(ConstrainedTypes)))),TRANSFORM(" + RELVARNAMES.USERDEFINEDTYPE + ",(" + ATTRIBUTENAMES.COMPONENTTYPENAME + "(TYPENAME),TYPESMANAGEFUNCTION(STRING(UserDefinedTypes))))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
			AbstractRelation r_userDefinedTypeNonPhysicalPossreps = startTransaction.execQueryAndEndTransaction("RESTRICT(JOIN(" + RELVARNAMES.UDTPOSSREP + ",GROUP(" + RELVARNAMES.UDTPOSSREPCOMPONENT + ",NONPHYSPRCOMPONENTS(COMPONENTNAME,SP_EXPRESSION)))," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

			UserDefinedType userDefinedType = r_userDefinedType.toObjectCollection(UserDefinedType.class).iterator().next();
			setPresentation("UserDefinedTypesManageDetails"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);
			setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, userDefinedType.getPhysicalPossrepName());
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, userDefinedType.getConstraintExpression());
			saveInFunctionContext(RELVARNAMES.USERDEFINEDTYPE, userDefinedType);

			if (r_userDefinedOrderingOperator.size() > 0) {
				UserDefinedOrderingOperator orderingOperatorExpression = r_userDefinedOrderingOperator.toObjectCollection(UserDefinedOrderingOperator.class).iterator().next();
				setPresentationValue("ORDERINGOPERATOREXPRESSION", orderingOperatorExpression.getExpression()); //$NON-NLS-1$
				saveInFunctionContext(RELVARNAMES.UDTORDERINGOPERATOR, orderingOperatorExpression);
			}

			setPresentationValue("PHYSICALPOSSREPCOMPONENTS", getWAARListValue("PHYSICALPOSSREPCOMPONENTS", r_userDefinedTypePhysicalPossrepComponents, null)); //$NON-NLS-1$ //$NON-NLS-2$
			setPresentationValue("NONPHYSICALPOSSREPS", getWAARListValue("NONPHYSICALPOSSREPS", r_userDefinedTypeNonPhysicalPossreps, new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION })))); //$NON-NLS-1$ //$NON-NLS-2$

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null) {
			processSelectedType();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(USERDEFINEDTYPESSELECT)) {
			// filename entered, ask confirmation
			processSelectedType();
		} else {
			// confirmation entered, delete type
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			UserDefinedType userDefinedType = (UserDefinedType) getFromFunctionContextMandatory(RELVARNAMES.USERDEFINEDTYPE);
			UserDefinedOrderingOperator orderingOperatorExpression = null;
			try {
				orderingOperatorExpression = (UserDefinedOrderingOperator) getFromFunctionContext(RELVARNAMES.UDTORDERINGOPERATOR);
			} catch (NotFoundException e2) {

			}

			String typeName = userDefinedType.getTypeName();
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, typeName);

			String newPhysicalPossrepName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME)).getString();
			userDefinedType.setPhysicalPossrepName(newPhysicalPossrepName);
			GenericStringValue wv_newConstraintExpression = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION);
			String newConstraintExpression = wv_newConstraintExpression == null ? "" : wv_newConstraintExpression.getString(); //$NON-NLS-1$
			userDefinedType.setConstraintExpression(newConstraintExpression);
			Collection<DmlAssignmentCommand> commands = new HashSet<DmlAssignmentCommand>();
			try {
				commands.add(userDefinedType.dbUpdateCommand(RELVARNAMES.USERDEFINEDTYPE));
			} catch (NoUpdatesException e1) {

			}

			GenericStringValue wv_newOrderingOperatorExpression = (GenericStringValue) getPresentationValue("ORDERINGOPERATOREXPRESSION"); //$NON-NLS-1$
			String newOrderingOperatorExpression = wv_newOrderingOperatorExpression == null ? "" : wv_newOrderingOperatorExpression.getString().trim(); //$NON-NLS-1$
			if (orderingOperatorExpression == null) {
				if (newOrderingOperatorExpression.length() > 0) {
					commands.add(new UserDefinedOrderingOperator(typeName, newOrderingOperatorExpression).dbAddCommand(RELVARNAMES.UDTORDERINGOPERATOR));
				}
			} else {
				if (newOrderingOperatorExpression.length() == 0) {
					commands.add(orderingOperatorExpression.dbDeleteCommand(RELVARNAMES.UDTORDERINGOPERATOR));
				} else {
					orderingOperatorExpression.setExpression(newOrderingOperatorExpression);
					try {
						commands.add(orderingOperatorExpression.dbUpdateCommand(RELVARNAMES.UDTORDERINGOPERATOR));
					} catch (NoUpdatesException e) {

					}
				}
			}

			if (commands.size() > 0) {
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
					leave = true;
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		// bit of dirty trix
		setPresentation(USERDEFINEDTYPESSELECT);
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, ((UserDefinedType) getFromFunctionContextMandatory(RELVARNAMES.USERDEFINEDTYPE)).getTypeName());
		processSelectedType();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return USERDEFINEDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}