package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a user-defined type.
 * 
 * @author Erwin
 */
public class UserDefinedTypesNonPhysicalPossrepsCreate extends UserDefinedTypesWebClientFunction {

	/**
	 * 
	 */
	private static final String POSSREPCOMPONENTTYPENAMES = "POSSREPCOMPONENTTYPENAMES"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String POSSREPCOMPONENTNAMES = "POSSREPCOMPONENTNAMES"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String CURRENTCOMPONENTNAME = "CURRENTCOMPONENTNAME"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String NONPHYSICALPOSSREPCOMPONENTNAMES = "NONPHYSICALPOSSREPCOMPONENTNAMES"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PHYSICALPOSSREPCOMPONENTNAMES = "PHYSICALPOSSREPCOMPONENTNAMES"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_INITIAL = "UserDefinedTypesNonPhysicalPossrepsCreate"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_PPC_EXPRESSIONS = "UserDefinedTypesNonPhysicalPossrepsCreatePPC_Expressions"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_THE_EXPRESSIONS = "UserDefinedTypesNonPhysicalPossrepsCreateTHE_Expressions"; //$NON-NLS-1$

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @param possrep
	 * @param possrepComponents
	 * @param physicalPossrepComponentsValueSelectors
	 * @param sirapriseServer
	 * @throws WAARApplicationException
	 */
	private void dbRegister (UserDefinedTypeNonPhysicalPossrep possrep, TreeMap<String, UserDefinedTypePossrepComponent> possrepComponents, TreeMap<String, UserDefinedTypePPCValueSelector> physicalPossrepComponentsValueSelectors, SiraPriseServer sirapriseServer) throws WAARApplicationException {
		Set<DmlAddCommand> cmds = new HashSet<DmlAddCommand>();
		cmds.add(possrep.dbAddCommand(RELVARNAMES.UDTPOSSREP));

		for (UserDefinedTypePossrepComponent possrepComponent : possrepComponents.values()) {
			cmds.add(possrepComponent.dbAddCommand(RELVARNAMES.UDTPOSSREPCOMPONENT));
		}

		for (UserDefinedTypePPCValueSelector physicalPossrepComponentsValueSelector : physicalPossrepComponentsValueSelectors.values()) {
			cmds.add(physicalPossrepComponentsValueSelector.dbAddCommand(RELVARNAMES.UDTPPCVALUESELECTOR));
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			revertToInitialPresentation();
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			revertToInitialPresentation();
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * 
	 */
	@SuppressWarnings("unchecked")
	private void revertToInitialPresentation ( ) {
		try {
			setPresentation(PRESENTATIONNAME_INITIAL);
			UserDefinedTypeNonPhysicalPossrep possrep = (UserDefinedTypeNonPhysicalPossrep) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREP);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, possrep.getTypeName());
			setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, possrep.getPossrepName());
			TreeMap<String, UserDefinedTypePossrepComponent> possrepComponents = (TreeMap<String, UserDefinedTypePossrepComponent>) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREPCOMPONENT);
			String componentNames = "", sep = "";  //$NON-NLS-1$//$NON-NLS-2$
			for (String possrepComponentName : possrepComponents.keySet()) {
				componentNames += (sep + possrepComponentName);
				sep = ","; //$NON-NLS-1$
			}
			setPresentationValue(POSSREPCOMPONENTNAMES, componentNames);
			LinkedList<String> possrepComponentTypeNames = (LinkedList<String>) getFromFunctionContextMandatory(POSSREPCOMPONENTTYPENAMES);
			String componentTypeNames = "";  //$NON-NLS-1$
			sep = ""; //$NON-NLS-1$
			for (String componentTypeName : possrepComponentTypeNames) {
				componentTypeNames += (sep + componentTypeName);
				sep = ","; //$NON-NLS-1$
			}
			setPresentationValue(POSSREPCOMPONENTTYPENAMES, componentTypeNames);
		} catch (WaarException e) {

		}

	}

	/**
	 * @param sirapriseServer
	 * @throws UnEqualNumberOfComponentNamesAndComponentTypeNamesException
	 * @throws NoConnectionException
	 * @throws PresentationNotSetException
	 * @throws WaarException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	@SuppressWarnings("unchecked")
	private void processInitialPresentation (SiraPriseServer sirapriseServer) throws WaarException {
		GenericStringValue wv_typeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		String typeName = wv_typeName.getString().trim();
		GenericStringValue wv_possrepName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME);
		String possrepName = wv_possrepName.getString().trim();
		GenericStringValue wv_possrepComponentNames = (GenericStringValue) getPresentationValue(POSSREPCOMPONENTNAMES);
		Set<String> possrepComponentNames = RelationValueSelectorFactory.getNamesInEntryOrderWithoutDuplicates(wv_possrepComponentNames == null ? "" : wv_possrepComponentNames.getString().trim()); //$NON-NLS-1$
		GenericStringValue wv_possrepComponentTypeNames = (GenericStringValue) getPresentationValue(POSSREPCOMPONENTTYPENAMES);
		LinkedList<String> possrepComponentTypeNames = RelationValueSelectorFactory.getNamesInEntryOrder(wv_possrepComponentTypeNames == null ? "" : wv_possrepComponentTypeNames.getString().trim()); //$NON-NLS-1$

		if (possrepComponentNames.size() != possrepComponentTypeNames.size()) {
			throw new UnEqualNumberOfComponentNamesAndComponentTypeNamesException(possrepComponentNames, possrepComponentTypeNames, getUserLocale());
		}

		saveInFunctionContext(POSSREPCOMPONENTTYPENAMES, possrepComponentTypeNames);
		
		// Fetch the physical possrep components of the type
		TreeMap<String, UserDefinedTypePPCValueSelector> m_physicalPossrepComponents;
		try {
			m_physicalPossrepComponents = (TreeMap<String, UserDefinedTypePPCValueSelector>) getFromFunctionContext(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT);
		} catch (NotFoundException e1) {
			//Get from database
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				Collection<UserDefinedTypePhysicalPossrepComponent> physicalPossrepComponents = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT + ",EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + ")))").toObjectCollection(UserDefinedTypePhysicalPossrepComponent.class); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$
				m_physicalPossrepComponents = new TreeMap<String, UserDefinedTypePPCValueSelector>();

				for (UserDefinedTypePhysicalPossrepComponent userDefinedTypePhysicalPossrepComponent : physicalPossrepComponents) {
					String physicalPossrepComponentName = userDefinedTypePhysicalPossrepComponent.getComponentName();
					m_physicalPossrepComponents.put(physicalPossrepComponentName, new UserDefinedTypePPCValueSelector(typeName, possrepName, physicalPossrepComponentName, "")); //$NON-NLS-1$
				}
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} catch (ConstructorMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
			} catch (SettersMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
			} finally {
				dbc.close();
			}
		}

		saveInFunctionContext(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT, m_physicalPossrepComponents);

		//The possrep object
		UserDefinedTypeNonPhysicalPossrep possrep = new UserDefinedTypeNonPhysicalPossrep(typeName, possrepName);
		saveInFunctionContext(RELVARNAMES.UDTPOSSREP, possrep);

		//The map of nonphysical possrep components
		TreeMap<String, UserDefinedTypePossrepComponent> possrepComponents;
		try {
			possrepComponents = (TreeMap<String, UserDefinedTypePossrepComponent>) getFromFunctionContext(RELVARNAMES.UDTPOSSREPCOMPONENT);
		} catch (NotFoundException e) {
			possrepComponents = new TreeMap<String, UserDefinedTypePossrepComponent>();
			saveInFunctionContext(RELVARNAMES.UDTPOSSREPCOMPONENT, possrepComponents);
		}

		//Remove all non-physical possrep components that were created in a previous pass but no longer are mentioned on this pass of the presentation
		Iterator<String> i_possrepComponents = possrepComponents.keySet().iterator();
		while (i_possrepComponents.hasNext()) {
			if (!possrepComponentNames.contains(i_possrepComponents.next())) {
				i_possrepComponents.remove();
			}
		}

		if (possrepComponentNames.size() > 0) {
			// Create the possrepComponent objects, and go cycling through the component names, asking the user to enter the THE_expression for that component
			Iterator<String> i_possrepComponentNames = possrepComponentNames.iterator();
			// Iterator<String> i_possrepComponentTypeNames = possrepComponentTypeNames.iterator();
			while (i_possrepComponentNames.hasNext()) {
				String possrepComponentName = i_possrepComponentNames.next();
				if (!possrepComponents.containsKey(possrepComponentName)) {
					possrepComponents.put(possrepComponentName, new UserDefinedTypePossrepComponent(typeName, possrepName, possrepComponentName, "")); //$NON-NLS-1$
				}
			}

			setPresentation(PRESENTATIONNAME_THE_EXPRESSIONS);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);
			setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, wv_possrepName);
			String currentComponentName = possrepComponentNames.iterator().next();
			setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, currentComponentName);
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, possrepComponents.get(currentComponentName).getComponentValueSelectorExpression());
			saveInFunctionContext(CURRENTCOMPONENTNAME, currentComponentName);
			setPresentationValue(PHYSICALPOSSREPCOMPONENTNAMES, m_physicalPossrepComponents.keySet().toString());
		} else {
			// New possrep without components (???) - must go create the PPCValueSelector expressions for each physical component of this type
			if (m_physicalPossrepComponents.size() > 0) {
				// New possrep has no components - still must go create PPCValueSelector expressions for each physical component (which in this case are constrained to just being literals)
				setPresentation(PRESENTATIONNAME_PPC_EXPRESSIONS);
				setSiraPriseServerPortPresentationValues(sirapriseServer);
				setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);
				setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, wv_possrepName);
				String currentComponentName = m_physicalPossrepComponents.keySet().iterator().next();
				setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, currentComponentName);
				setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, m_physicalPossrepComponents.get(currentComponentName).getPpcComponentValueSelectorExpression());
				saveInFunctionContext(CURRENTCOMPONENTNAME, currentComponentName);
				setPresentationValue(NONPHYSICALPOSSREPCOMPONENTNAMES, possrepComponents.keySet().toString());
			} else {
				// No components, and no physical components ===> register this
				dbRegister(possrep, possrepComponents, m_physicalPossrepComponents, sirapriseServer);
				leave = true;
			}
		}
	}

	/**
	 * @param sirapriseServer
	 * @throws FunctionContextDoesNotHoldThisPropertyException
	 * @throws WaarException
	 * @throws PresentationNotSetException
	 */
	@SuppressWarnings("unchecked")
	private void processTHE_ExpressionsPresentation (SiraPriseServer sirapriseServer) throws WaarException {
		// A THE_ expression has been entered for some component of the possrep.
		// Get this component from the function context, update its object to hold the entered expression,
		// switch to the next component if there is one,
		// if there is none, then switch to the PPC screens if there are any physical possrep components,
		// or go register the stuff if there are no physical possrep components.
		UserDefinedTypeNonPhysicalPossrep possrep = (UserDefinedTypeNonPhysicalPossrep) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREP);
		TreeMap<String, UserDefinedTypePossrepComponent> possrepComponents = (TreeMap<String, UserDefinedTypePossrepComponent>) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREPCOMPONENT);
		TreeMap<String, UserDefinedTypePPCValueSelector> m_physicalPossrepComponents = (TreeMap<String, UserDefinedTypePPCValueSelector>) getFromFunctionContextMandatory(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT);
		String currentComponentName = (String) getFromFunctionContextMandatory(CURRENTCOMPONENTNAME);

		UserDefinedTypePossrepComponent currentComponent = possrepComponents.get(currentComponentName);
		currentComponent.setComponentValueSelectorExpression(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString());

		Iterator<String> i = possrepComponents.tailMap(currentComponentName + " ").keySet().iterator(); //$NON-NLS-1$
		if (i.hasNext()) {
			// Still other components to be completed
			currentComponentName = i.next();
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, possrep.getTypeName());
			setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, possrep.getPossrepName());
			setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, currentComponentName);
			setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, possrepComponents.get(currentComponentName).getComponentValueSelectorExpression());
			saveInFunctionContext(CURRENTCOMPONENTNAME, currentComponentName);
			setPresentationValue(PHYSICALPOSSREPCOMPONENTNAMES, m_physicalPossrepComponents.keySet().toString());
		} else {
			// Switch to the PPC presentation, unless there are no physical possrep components, in which case go do dbRegister
			if (m_physicalPossrepComponents.size() < 1) {
				dbRegister(possrep, possrepComponents, m_physicalPossrepComponents, sirapriseServer);
				leave = true;
			} else {
				// New possrep has no components - still must go create PPCValueSelector expressions for each physical component (which in this case are constrained to just being literals)
				setPresentation(PRESENTATIONNAME_PPC_EXPRESSIONS);
				setSiraPriseServerPortPresentationValues(sirapriseServer);
				setPresentationValue(ATTRIBUTENAMES.TYPENAME, possrep.getTypeName());
				setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, possrep.getPossrepName());
				currentComponentName = m_physicalPossrepComponents.keySet().iterator().next();
				setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, currentComponentName);
				saveInFunctionContext(CURRENTCOMPONENTNAME, currentComponentName);
				setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, m_physicalPossrepComponents.get(currentComponentName).getPpcComponentValueSelectorExpression());
				setPresentationValue(NONPHYSICALPOSSREPCOMPONENTNAMES, possrepComponents.keySet().toString());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doActionLogic(java.lang.String)
	 */
	@Override
	public void doActionLogic (String action) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(PRESENTATIONNAME_THE_EXPRESSIONS)) {
			if (action.equalsIgnoreCase("PREVCOMPONENT")) { //$NON-NLS-1$
				// TODO scroll through the screens stack
			} else {
				if (action.equalsIgnoreCase("NEXTCOMPONENT")) { //$NON-NLS-1$
					// TODO scroll through the screens stack
				} else {
					super.doActionLogic(action);
				}
			}
		}

		if (getPresentation().getName().equalsIgnoreCase(PRESENTATIONNAME_PPC_EXPRESSIONS)) {
			if (action.equalsIgnoreCase("PREVCOMPONENT")) { //$NON-NLS-1$
				// TODO scroll through the screens stack
			} else {
				if (action.equalsIgnoreCase("NEXTCOMPONENT")) { //$NON-NLS-1$
					// TODO scroll through the screens stack
				} else {
					super.doActionLogic(action);
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	@SuppressWarnings("unchecked")
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentation().getName().equalsIgnoreCase(PRESENTATIONNAME_INITIAL)) {
			processInitialPresentation(sirapriseServer);
		} else {
			if (getPresentation().getName().equalsIgnoreCase(PRESENTATIONNAME_THE_EXPRESSIONS)) {
				processTHE_ExpressionsPresentation(sirapriseServer);
			} else {
				// A PPC_ expression has been entered for some component of the physical possrep
				UserDefinedTypeNonPhysicalPossrep possrep = (UserDefinedTypeNonPhysicalPossrep) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREP);
				TreeMap<String, UserDefinedTypePossrepComponent> possrepComponents = (TreeMap<String, UserDefinedTypePossrepComponent>) getFromFunctionContextMandatory(RELVARNAMES.UDTPOSSREPCOMPONENT);
				TreeMap<String, UserDefinedTypePPCValueSelector> m_physicalPossrepComponents = (TreeMap<String, UserDefinedTypePPCValueSelector>) getFromFunctionContextMandatory(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT);
				String currentComponentName = (String) getFromFunctionContextMandatory(CURRENTCOMPONENTNAME);

				UserDefinedTypePPCValueSelector currentPhysicalPossrepComponentValueSelector = m_physicalPossrepComponents.get(currentComponentName);
				currentPhysicalPossrepComponentValueSelector.setPpcComponentValueSelectorExpression(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString());

				Iterator<String> i = m_physicalPossrepComponents.tailMap(currentComponentName + " ").keySet().iterator(); //$NON-NLS-1$
				if (i.hasNext()) {
					currentComponentName = i.next();
					setSiraPriseServerPortPresentationValues(sirapriseServer);
					setPresentationValue(ATTRIBUTENAMES.TYPENAME, possrep.getTypeName());
					setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, possrep.getPossrepName());
					setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, currentComponentName);
					saveInFunctionContext(CURRENTCOMPONENTNAME, currentComponentName);
					setPresentationValue(NONPHYSICALPOSSREPCOMPONENTNAMES, possrepComponents.keySet().toString());
					setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, m_physicalPossrepComponents.get(currentComponentName).getPpcComponentValueSelectorExpression());
				} else {
					dbRegister(possrep, possrepComponents, m_physicalPossrepComponents, sirapriseServer);
					leave = true;
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesNonPhysicalPossrepsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
