package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlDeleteCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a user-defined type.
 * 
 * @author Erwin
 */
public class UserDefinedTypesNonPhysicalPossrepsDelete extends UserDefinedTypesWebClientFunction {

	/**
	 * 
	 */
	private static final String COMMANDS = "COMMANDS"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRM = "UserDefinedTypesNonPhysicalPossrepDeleteConfirm"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_INITIAL = "UserDefinedTypesNonPhysicalPossrepsSelect"; //$NON-NLS-1$

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws UnEqualNumberOfComponentNamesAndComponentTypeNamesException
	 * @throws NoConnectionException
	 * @throws PresentationNotSetException
	 * @throws WaarException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	private void processSelectedPossrep ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_typeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		String typeName = wv_typeName.getString().trim();
		GenericStringValue wv_possrepName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME);
		String possrepName = wv_possrepName.getString().trim();

		// Get the objects to be deleted from the database : all the components, and all the PPCValueSelectors for this non-physical possrep
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			String restrictCondition = "AND(EQ(" + ATTRIBUTENAMES.POSSREPNAME + ",NAME(" + possrepName + ")),EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			Collection<UserDefinedTypeNonPhysicalPossrep> possrep = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPOSSREP + "," + restrictCondition + ")").toObjectCollection(UserDefinedTypeNonPhysicalPossrep.class); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			Collection<UserDefinedTypePossrepComponent> possrepComponents = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPOSSREPCOMPONENT + "," + restrictCondition + ")").toObjectCollection(UserDefinedTypePossrepComponent.class); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			Collection<UserDefinedTypePPCValueSelector> physicalPossrepComponents = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.UDTPPCVALUESELECTOR + "," + restrictCondition + ")").toObjectCollection(UserDefinedTypePPCValueSelector.class); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$

			if (possrep.size() < 1) {
				throw new NonPhysicalPossrepNotFoundException(typeName, possrepName, getUserLocale());
			}

			setPresentation(PRESENTATIONNAME_DELETECONFIRM);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);
			setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, wv_possrepName);

			Set<DmlDeleteCommand> deleteCommands = new HashSet<DmlDeleteCommand>();
			deleteCommands.add(possrep.iterator().next().dbDeleteCommand(RELVARNAMES.UDTPOSSREP));
			for (UserDefinedTypePossrepComponent possrepComponent : possrepComponents) {
				deleteCommands.add(possrepComponent.dbDeleteCommand(RELVARNAMES.UDTPOSSREPCOMPONENT));
			}
			for (UserDefinedTypePPCValueSelector physicalPossrepComponent : physicalPossrepComponents) {
				deleteCommands.add(physicalPossrepComponent.dbDeleteCommand(RELVARNAMES.UDTPPCVALUESELECTOR));
			}

			saveInFunctionContext(COMMANDS, deleteCommands);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		if (((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)) != null && ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME)) != null) {
			processSelectedPossrep();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	@SuppressWarnings("unchecked")
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentation().getName().equalsIgnoreCase(PRESENTATIONNAME_INITIAL)) {
			processSelectedPossrep();
		} else {
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction((Set<DmlDeleteCommand>) getFromFunctionContextMandatory(COMMANDS)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return PRESENTATIONNAME_INITIAL;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesNonPhysicalPossrepsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
