package be.SIRAPRISE.webclient;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.Map.Entry;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.util.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a user-defined type.
 * 
 * @author Erwin
 */
public class UserDefinedTypesPhysicalPossrepComponentsCreate extends UserDefinedTypesWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * @throws UnEqualNumberOfComponentNamesAndComponentTypeNamesException
	 * @throws NoConnectionException
	 * @throws ExpectedBracketsMissingException
	 * @throws PresentationNotSetException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	private void processInitialPresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String typeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();
		GenericStringValue wv_possrepComponentNames = (GenericStringValue) getPresentationValue("POSSREPCOMPONENTNAMES"); //$NON-NLS-1$
		Set<String> possrepComponentNames = RelationValueSelectorFactory.getNamesInEntryOrderWithoutDuplicates(wv_possrepComponentNames == null ? "" : wv_possrepComponentNames.getString().trim()); //$NON-NLS-1$
		GenericStringValue wv_possrepComponentTypeNames = (GenericStringValue) getPresentationValue("POSSREPCOMPONENTTYPENAMES"); //$NON-NLS-1$
		LinkedList<String> possrepComponentTypeNames = RelationValueSelectorFactory.getNamesInEntryOrder(wv_possrepComponentTypeNames == null ? "" : wv_possrepComponentTypeNames.getString().trim()); //$NON-NLS-1$

		if (possrepComponentNames.size() != possrepComponentTypeNames.size()) {
			throw new UnEqualNumberOfComponentNamesAndComponentTypeNamesException(possrepComponentNames, possrepComponentTypeNames, getUserLocale());
		}

		Set<DmlAddCommand> cmds = new HashSet<DmlAddCommand>();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String typeNameCondition = "EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			int ordinal = Math.max(startTransaction.execQuery("AGGREGATE(RESTRICT(" + RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT + "," + typeNameCondition + ")," + ATTRIBUTENAMES.ORDINAL + "(MAX(" + ATTRIBUTENAMES.ORDINAL + ")))").toObjectCollection(UserDefinedTypePhysicalPossrepComponent.class).iterator().next().getOrdinal(), 0) + 10; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			AbstractRelation r_nonPhysicalPossreps = startTransaction.execQuery("RESTRICT(GROUP(PROJECT(" + RELVARNAMES.UDTPOSSREPCOMPONENT + ",(" + ATTRIBUTENAMES.COMPONENTNAME + "," + ATTRIBUTENAMES.POSSREPNAME + "," + ATTRIBUTENAMES.TYPENAME + ")),COMPONENTS(" + ATTRIBUTENAMES.COMPONENTNAME + "))," + typeNameCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			LinkedHashMap<RequiredPPCID, DmlAddCommand> requiredPPCs = new LinkedHashMap<RequiredPPCID, DmlAddCommand>();
			LinkedHashMap<RequiredPPCID, AbstractRelation> requiredPPCsInfo = new LinkedHashMap<RequiredPPCID, AbstractRelation>();
			Iterator<String> i_possrepComponentNames = possrepComponentNames.iterator();
			Iterator<String> i_possrepComponentTypeNames = possrepComponentTypeNames.iterator();
			while (i_possrepComponentNames.hasNext()) {
				String possrepComponentName = i_possrepComponentNames.next();
				String possrepComponentTypeSpec = i_possrepComponentTypeNames.next();
				int possrepComponentTypeLogicalLength;
				String possrepComponentTypeName;
				try {
					NameValuePair nvr = BracketParser.getNameAndMandatoryValueFromNonEscaped(possrepComponentTypeSpec, 0).getNameValuePair();
					possrepComponentTypeName = nvr.getName();
					possrepComponentTypeLogicalLength = Integer.parseInt(nvr.getValue());
				} catch (NoClosingBracketException e) {
					throw new ExpectedBracketsMissingException(possrepComponentTypeSpec, getUserLocale());
				} catch (NoOpeningBracketException e) {
					possrepComponentTypeName = possrepComponentTypeSpec;
					possrepComponentTypeLogicalLength = 0;
				}
				cmds.add(new UDTPhysicalPossrepComponent(typeName, possrepComponentName, possrepComponentTypeName, possrepComponentTypeLogicalLength, (ordinal += 10)).dbAddCommand(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT));
				for (Tuple tuple : r_nonPhysicalPossreps) {
					requiredPPCs.put(new RequiredPPCID(possrepComponentName, tuple.value(ATTRIBUTENAMES.POSSREPNAME)), null);
					requiredPPCsInfo.put(new RequiredPPCID(possrepComponentName, tuple.value(ATTRIBUTENAMES.POSSREPNAME)), tuple.rvaValue("COMPONENTS")); //$NON-NLS-1$
				}
			}

			if (requiredPPCs.size() < 1) {
				startTransaction.execMultipleStatementAndEndTransaction(cmds);
				leave = true;
			} else {
				saveInFunctionContext("COMMANDS", cmds); //$NON-NLS-1$
				saveInFunctionContext("REQUIREDPPCS", requiredPPCs); //$NON-NLS-1$
				saveInFunctionContext("REQUIREDPPCSINFO", requiredPPCsInfo); //$NON-NLS-1$
				setPresentation("UserDefinedTypesNonPhysicalPossrepsCreatePPC_Expressions"); //$NON-NLS-1$
				setSiraPriseServerPortPresentationValues();
				setPresentationValue(ATTRIBUTENAMES.TYPENAME, typeName);
				RequiredPPCID requiredPPCID = requiredPPCs.keySet().iterator().next();
				setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, requiredPPCID.getNonPhysicalPossrepName());
				setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, requiredPPCID.getPhysicalPossrepComponentName());
				setPresentationValue("NONPHYSICALPOSSREPCOMPONENTNAMES", RelationValueSelectorFactory.getRelationAttributeValueCommalist(requiredPPCsInfo.get(requiredPPCID), ATTRIBUTENAMES.COMPONENTNAME)); //$NON-NLS-1$
			}
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 * 
	 */
	@SuppressWarnings("unchecked")
	private void processRequiredPPCPresentation ( ) throws WaarException {
		String expression = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim();
		String typeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();
		String nonPhysicalPossrepName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.POSSREPNAME)).getString().trim();
		String physicalPossrepComponentName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.COMPONENTNAME)).getString().trim();
		DmlAddCommand valueSelectorCommand = new UserDefinedTypePPCValueSelector(typeName, nonPhysicalPossrepName, physicalPossrepComponentName, expression).dbAddCommand(RELVARNAMES.UDTPPCVALUESELECTOR);

		LinkedHashMap<RequiredPPCID, DmlAddCommand> requiredPPCs = (LinkedHashMap<RequiredPPCID, DmlAddCommand>) getFromFunctionContextMandatory("REQUIREDPPCS"); //$NON-NLS-1$
		requiredPPCs.put(new RequiredPPCID(physicalPossrepComponentName, nonPhysicalPossrepName), valueSelectorCommand);

		boolean canDoUpdate = true;
		for (Entry<RequiredPPCID, DmlAddCommand> me : requiredPPCs.entrySet()) {
			if (me.getValue() == null) {
				RequiredPPCID requiredPPCID = me.getKey();
				LinkedHashMap<RequiredPPCID, AbstractRelation> requiredPPCsInfo = (LinkedHashMap<RequiredPPCID, AbstractRelation>) getFromFunctionContextMandatory("REQUIREDPPCSINFO"); //$NON-NLS-1$
				setPresentationValue(ATTRIBUTENAMES.POSSREPNAME, requiredPPCID.getNonPhysicalPossrepName());
				setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, requiredPPCID.getPhysicalPossrepComponentName());
				setPresentationValue("NONPHYSICALPOSSREPCOMPONENTNAMES", RelationValueSelectorFactory.getRelationAttributeValueCommalist(requiredPPCsInfo.get(requiredPPCID), ATTRIBUTENAMES.COMPONENTNAME)); //$NON-NLS-1$
				canDoUpdate = false;
			}
		}

		if (canDoUpdate) {
			Set<DmlAddCommand> cmds = (Set<DmlAddCommand>) getFromFunctionContextMandatory("COMMANDS"); //$NON-NLS-1$
			cmds.addAll(requiredPPCs.values());
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction().execMultipleStatementAndEndTransaction(cmds);
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("UserDefinedTypesPhysicalPossrepComponentsCreate")) { //$NON-NLS-1$
			processInitialPresentation();
		} else {
			processRequiredPPCPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesPhysicalPossrepComponentsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
