package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a user-defined type.
 * 
 * @author Erwin
 */
public class UserDefinedTypesPhysicalPossrepComponentsDelete extends UserDefinedTypesWebClientFunction {

	/**
	 * 
	 */
	private static final String COMMANDS = "COMMANDS"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String USERDEFINEDTYPESPHYSICALPOSSREPCOMPONENTSDELETECONFIRM = "UserDefinedTypesPhysicalPossrepComponentsDeleteConfirm"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String USERDEFINEDTYPESPHYSICALPOSSREPCOMPONENTSSELECT = "UserDefinedTypesPhysicalPossrepComponentsSelect"; //$NON-NLS-1$

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * 
	 */
	private void processSelectedPhysicalComponent ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		WaarValue wv_typeName = getPresentationValue(ATTRIBUTENAMES.TYPENAME);
		String typeName = ((GenericStringValue) wv_typeName).getString().trim();
		WaarValue wv_componentName = getPresentationValue(ATTRIBUTENAMES.COMPONENTNAME);
		String componentName = ((GenericStringValue) wv_componentName).getString().trim();

		// Get the basetypename and the constraintexpression to save it in the sessioncontext
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String typeNameCondition = "AND(EQ(" + ATTRIBUTENAMES.COMPONENTNAME + ",NAME(" + componentName + ")),EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			AbstractRelation r_physicalPossrepComponent = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (r_physicalPossrepComponent.size() < 1) {
				throw new PhysicalPossrepComponentNotFoundException(typeName, componentName, getUserLocale());
			}

			// Get all the value selectors that exist for this physical component (1 per non-physical possrep - these must also be deleted)
			AbstractRelation r_userDefinedTypePPCValueSelectors = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.UDTPPCVALUESELECTOR + "," + typeNameCondition + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			Set<DmlAssignmentCommand> dmlDeleteCommands = new HashSet<DmlAssignmentCommand>();

			UserDefinedTypePhysicalPossrepComponent physicalPossrepComponent = DBObjectFactory.getObject(r_physicalPossrepComponent.iterator().next(), UserDefinedTypePhysicalPossrepComponent.class);
			dmlDeleteCommands.add(physicalPossrepComponent.dbDeleteCommand(RELVARNAMES.UDTPHYSICALPOSSREPCOMPONENT));

			// The deletecommand for the ordering operator, if there is one
			Collection<UserDefinedTypePPCValueSelector> userDefinedTypePPCValueSelectors = r_userDefinedTypePPCValueSelectors.toObjectCollection(UserDefinedTypePPCValueSelector.class);
			for (UserDefinedTypePPCValueSelector userDefinedTypePPCValueSelector : userDefinedTypePPCValueSelectors) {
				dmlDeleteCommands.add(userDefinedTypePPCValueSelector.dbDeleteCommand(RELVARNAMES.UDTPPCVALUESELECTOR));
			}

			setPresentation(USERDEFINEDTYPESPHYSICALPOSSREPCOMPONENTSDELETECONFIRM);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.TYPENAME, wv_typeName);
			setPresentationValue(ATTRIBUTENAMES.COMPONENTNAME, wv_componentName);
			setPresentationValue(ATTRIBUTENAMES.COMPONENTTYPENAME, physicalPossrepComponent.getComponentTypeName());

			saveInFunctionContext(COMMANDS, dmlDeleteCommands);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null && getPresentationValue(ATTRIBUTENAMES.COMPONENTNAME) != null) {
			processSelectedPhysicalComponent();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	@SuppressWarnings("unchecked")
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(USERDEFINEDTYPESPHYSICALPOSSREPCOMPONENTSSELECT)) {
			processSelectedPhysicalComponent();
		} else {
			// process delete confirmation
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction((Set<DmlDeleteCommand>) getFromFunctionContextMandatory(COMMANDS)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return USERDEFINEDTYPESPHYSICALPOSSREPCOMPONENTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UserDefinedTypesPhysicalPossrepComponentsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}
