package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.User;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a user
 * 
 * @author Erwin
 */
public class UsersDelete extends UsersWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedUser ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		User user = getUser(siraPriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.USERID)).getString().trim());

		setPresentation("UsersDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.USERID, user.getUserID());

		saveInFunctionContext(RELVARNAMES.USER, user);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		if (getPresentationValue(ATTRIBUTENAMES.USERID) != null) {
			processSelectedUser();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(USERSSELECT)) {
			// attributename entered, ask confirmation
			processSelectedUser();
		} else {
			// confirmation entered, delete attribute
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

			User user = (User) getFromFunctionContextMandatory(RELVARNAMES.USER);
			GenericStringValue wv_userID = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.USERID);
			String userID = wv_userID.getString().trim();
			user.setUserID(userID);
			setPresentationValue(ATTRIBUTENAMES.USERID, wv_userID);

			DBConnection dbc = getDBConnection(siraPriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { user.dbDeleteCommand(RELVARNAMES.USER).getCommand(), ("UNASSERT " + RELVARNAMES.USERCERTIFICATE + ",RESTRICT(" + RELVARNAMES.USERCERTIFICATE + ",EQ(" + ATTRIBUTENAMES.USERID + ",NAME(" + userID + ")))") }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return USERSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UsersDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}