package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.User;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of an attribute
 * 
 * @author Erwin
 */
public class UsersManage extends UsersWebClientFunction {

	/**
	 * Reads the details of the selected attribute in the catalog and displays those on screen
	 * 
	 * @throws WaarException
	 */
	private void processSelectedUser ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_userID = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.USERID));
		User user = getUser(siraPriseServer, wv_userID.getString().trim());
		
		setPresentation("UsersManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.USERID, wv_userID);

		saveInFunctionContext(RELVARNAMES.USER, user);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.USERID) != null) {
			processSelectedUser();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(USERSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedUser();
		} else {
			// <OK> clicked on managedetails presentation ; try to modify attribute definition
			SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();
			
			User user = (User) getFromFunctionContextMandatory(RELVARNAMES.USER);

			user.setUserID(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.USERID)).getString().trim());

			DBConnection dbc = getDBConnection(siraPriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbUpdateAndEndTransaction(RELVARNAMES.USER, user); //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return USERSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "UsersManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}