/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.User;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 *
 */
abstract class UsersWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String USERSSELECT = "USERSSELECT"; //$NON-NLS-1$

	/**
	 * @param siraPriseServer
	 * @param userID
	 * @return
	 * @throws NoConnectionException
	 * @throws UserNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final User getUser (SiraPriseServer siraPriseServer, String userID) throws NoConnectionException, UserNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(" + RELVARNAMES.USER + ",EQ(" + ATTRIBUTENAMES.USERID + ",NAME(" + userID + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			if (rsp.size() < 1) {
				throw new UserNotFoundException(userID, getUserLocale());
			}
			return rsp.toObjectCollection(User.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}
}
