package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.VirtualRelvar;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete an virtual relvar
 * 
 * @author Erwin
 */
public class VirtualRelvarsDelete extends VirtualRelvarsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedVirtualRelvar ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME); 
		String relvarName = wv_relvarName.getString();

		VirtualRelvar virtualRelvar = getVirtualRelvar(relvarName);
		saveInFunctionContext(RELVARNAMES.VIRTUALRELVAR, virtualRelvar); 

		setPresentation("VirtualRelvarsDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
		setPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION, virtualRelvar.getExpression());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null) {
			processSelectedVirtualRelvar();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(VIRTUALRELVARSSELECT)) {
			// errorcode entered, ask confirmation
			processSelectedVirtualRelvar();
		} else {
			// confirmation entered, delete constraint
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			VirtualRelvar virtualRelvar = (VirtualRelvar) getFromFunctionContextMandatory(RELVARNAMES.VIRTUALRELVAR);
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbDeleteAndEndTransaction(RELVARNAMES.VIRTUALRELVAR, virtualRelvar);   //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return VIRTUALRELVARSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "VirtualRelvarsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}