package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.jsba.VirtualRelvar;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a virtual relvar
 * 
 * @author Erwin
 */
public class VirtualRelvarsManage extends VirtualRelvarsWebClientFunction {

	/**
	 * 
	 */
	private static final String ATTRIBUTELIST = "ATTRIBUTELIST"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String INFERREDKEYLIST = "INFERREDKEYLIST"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String KEYLIST = "KEYLIST"; //$NON-NLS-1$

	/**
	 * @throws WaarException
	 */
	private void processSelectedVirtualRelvar ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();
		VirtualRelvar virtualRelvar = getVirtualRelvar(relvarName);

		setPresentation("VirtualRelvarsManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, relvarName);
		setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, virtualRelvar.getExpression());
		Tuple y = ((AbstractRelation) getFromFunctionContextMandatory(INFO)).iterator().next();
		setPresentationValue(KEYLIST, getWAARListValue(KEYLIST, y.rvaValue("KEYS"), null)); //$NON-NLS-1$
		setPresentationValue(INFERREDKEYLIST, getWAARListValue(INFERREDKEYLIST, y.rvaValue("INFERREDKEYS"), null)); //$NON-NLS-1$
		setPresentationValue(ATTRIBUTELIST, getWAARListValue(ATTRIBUTELIST, y.rvaValue("NONSCALARHEADING"), null)); //$NON-NLS-1$

		saveInFunctionContext(RELVARNAMES.VIRTUALRELVAR, virtualRelvar);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null) {
			processSelectedVirtualRelvar();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(VIRTUALRELVARSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedVirtualRelvar();
		} else {
			// new dbms file details entered, update the catalog
			VirtualRelvar virtualRelvar = (VirtualRelvar) getFromFunctionContextMandatory(RELVARNAMES.VIRTUALRELVAR);

			virtualRelvar.setExpression(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim());
			virtualRelvar.setRelvarName(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString());

			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbUpdateAndEndTransaction(RELVARNAMES.VIRTUALRELVAR, virtualRelvar); //$NON-NLS-1$
				processSelectedVirtualRelvar();
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return VIRTUALRELVARSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "VirtualRelvarsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}