package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class VirtualRelvarsOverview extends VirtualRelvarsWebClientFunction {

	/**
	 * 
	 */
	private static final String NAMEPATTERN = "NAMEPATTERN"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String RELVARLIST = "RELVARLIST"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(NAMEPATTERN) != null || getPresentationValue(ATTRIBUTENAMES.REFERENCEDRELVARNAME) != null) {
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		String queryExpression = RELVARNAMES.VIRTUALRELVAR;
		WaarValue wv_referencedRelvarNames = getPresentationValue(ATTRIBUTENAMES.REFERENCEDRELVARNAME);
		if (wv_referencedRelvarNames != null) {
			final LogicalValue wv_includeIndirectReferences = (LogicalValue) getPresentationValue("INCLUDEINDIRECTREFERENCES"); //$NON-NLS-1$
			queryExpression = "JOIN(" + ((wv_includeIndirectReferences != null && wv_includeIndirectReferences.getValue()) ? RELVARNAMES.VIRTUALRELVARDEPENDENCYGRAPH : RELVARNAMES.VIRTUALRELVARREFERENCES) + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(((GenericStringValue) wv_referencedRelvarNames).getString().trim()), ATTRIBUTENAMES.REFERENCEDRELVARNAME, TYPENAMES.NAME) + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
		}

		GenericStringValue namePattern = (GenericStringValue) getPresentationValue(NAMEPATTERN);
		if (namePattern != null) {
			queryExpression = "RESTRICT(" + queryExpression + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + BracketParser.meta(namePattern.getString()) + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}

		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			setPresentationValue(RELVARLIST, getWAARListValue(RELVARLIST, dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(queryExpression), null)); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "VirtualRelvarsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}