/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.VirtualRelvar;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 * 
 */
abstract class VirtualRelvarsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String INFO = "INFO"; //$NON-NLS-1$

	/**
	 * Comment for <code>VIRTUALRELVARSSELECT</code>
	 */
	static final String VIRTUALRELVARSSELECT = "VirtualRelvarsSelect"; //$NON-NLS-1$

	/**
	 * 
	 * @param relvarName
	 * @return
	 * @throws NoConnectionException
	 * @throws VirtualRelvarNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final VirtualRelvar getVirtualRelvar (String relvarName) throws NoConnectionException, VirtualRelvarNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(getSiraPriseServer());
		try {
			AbstractRelation r = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("PROJECT(UNGROUP(TRANSFORM(RESTRICT(LEFTJOIN(" + RELVARNAMES.VIRTUALRELVAR + ",GROUP(LEFTJOIN(" + RELVARNAMES.KEY + ",GROUP(" + RELVARNAMES.KEYATTRIBUTE + ",KEYATTRIBUTES(ATTRIBUTENAME)),KEYATTRIBUTES(RELATION(HEADING(KEYATTRIBUTES(RELATION(HEADING(ATTRIBUTENAME(NAME)))))BODY()))),KEYS(ERRORCODE,KEYATTRIBUTES)),KEYS(RELATION(HEADING(ERRORCODE(LONG)KEYATTRIBUTES(RELATION(HEADING(ATTRIBUTENAME(NAME)))))BODY()))),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))),RELVARNAME,KEYS,INFO(EXPRESSIONINFO(SP_EXPRESSION))),(INFO)),(RELVARNAME,SP_EXPRESSION,NONSCALARHEADING,INFERREDKEYS,KEYS))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			if (r.size() < 1) {
				throw new VirtualRelvarNotFoundException(relvarName, getUserLocale());
			}
			saveInFunctionContext(INFO, r);
			return DBObjectFactory.getObjectIgnoringMissingSetters(r.iterator().next(), VirtualRelvar.class);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}
}
