/*
 * Created on 16-okt-2008
 */
package be.SIRAPRISE.client;

import java.util.*;

/**
 * The AbstractRelation provides an implementation for the Relation interface
 * 
 * @author Erwin Smout
 */
public abstract class AbstractRelation extends AbstractTupleContainer implements Relation {

	/**
	 * The Set object that will give us the Set interface methods. The behaviour of the iterator() method (in particular the iteration order) will be determined by the type of Set that is passed to this method.
	 */
	private Set<Tuple> set;

	/**
	 * Creates the container, setting the intended heading for the tuples and the underlying Set object
	 * 
	 * @param heading
	 *            The heading for tuple container.
	 * @param set
	 *            The Set object that will give us the Set interface methods. The behaviour of the iterator() method (in particular the iteration order) will be determined by the type of Set that is passed to this method.
	 */
	public AbstractRelation (Heading heading, Set<Tuple> set) {
		super(heading);
		this.set = set;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#addTupleWithoutHeadingCheck(be.SIRAPRISE.client.AbstractTuple)
	 */
	public final void addTupleWithoutHeadingCheck (Tuple tuple) {
		try {
			if (addOK(tuple)) {
				set.add(tuple);
			}
		} catch (NoSuchMethodError e) { // for backward compatibility with prior implementations that do not have the addOK() method
			set.add(tuple);
		}
	}

	/**
	 * "exit" method called by the addTuple() methods to check if it is OK to add the given tuple to this relation. This method should return false only in very specific circumstances.
	 * 
	 * @param tuple
	 *            The tuple about to be added to the relation.
	 * @return true if it is OK to add the tuple to the given relation.
	 */
	public abstract boolean addOK (Tuple tuple);

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#containsAllTuples(be.SIRAPRISE.client.TupleContainer)
	 */
	public final boolean containsTuples (TupleContainer tupleContainer) {
		Iterator<Tuple> i_tupleContainer = tupleContainer.iterator();
		while (i_tupleContainer.hasNext()) {
			if (!containsTuple(i_tupleContainer.next())) {
				return false;
			}
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#containsTuple(be.SIRAPRISE.client.Tuple)
	 */
	public final boolean containsTuple (Tuple t) {
		return set.contains(t);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public final boolean equals (Object obj) {
		return obj instanceof AbstractRelation && set.equals(((AbstractRelation) obj).set);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainerWithoutDuplicates#getTupleSet()
	 */
	public final Set<Tuple> getTupleSet ( ) {
		return set;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public final int hashCode ( ) {
		return set.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#iterator()
	 */
	public final Iterator<Tuple> iterator ( ) {
		return set.iterator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#size()
	 */
	public final int size ( ) {
		return set.size();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.AbstractTupleContainer#removeTuple(be.SIRAPRISE.client.AbstractTuple)
	 */
	public final boolean removeTuple (Tuple t) {
		return set.remove(t);
	}

	/**
	 * 
	 */
	public final void clear ( ) {
		set.clear();
	}
}