/*
 * Created on 8-okt-2008
 */
package be.SIRAPRISE.client;

import java.util.*;

/**
 * Abstract implementation of the TupleBag interface
 * 
 * @author Erwin Smout
 */
public abstract class AbstractTupleBag extends AbstractTupleContainer implements TupleBag {

	/**
	 * The list underlying the Collection behaviour of the TupleBag
	 */
	private List<Tuple> list;

	/**
	 * Creates the TupleBag
	 * 
	 * @param heading
	 *            The Heading that all tuples in the bag must be guaranteed to conform to
	 * @param list
	 *            The list underlying the Collection behaviour of the TupleBag
	 */
	public AbstractTupleBag (Heading heading, List<Tuple> list) {
		super(heading);
		this.list = list;
	}

	/**
	 * "exit" method called by the addTuple() methods to check if it is OK to add the given tuple to this relation. This method should return false only in very specific circumstances.
	 * 
	 * @param tuple
	 *            The tuple about to be added to the relation.
	 * @return true if it is OK to add the tuple to the given relation.
	 */
	public abstract boolean addOK (Tuple tuple);

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.server.TupleContainer#addTuple(be.SIRAPRISE.server.STuple)
	 */
	public final void addTupleWithoutHeadingCheck (Tuple t) {
		list.add(t);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Collection#clear()
	 */
	public final void clear ( ) {
		list.clear();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#containsTuple(be.SIRAPRISE.client.Tuple)
	 */
	public final boolean containsTuple (Tuple t) {
		return list.contains(t);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.TupleContainer#containsAllTuples(be.SIRAPRISE.client.TupleContainer)
	 */
	public final boolean containsTuples (TupleContainer tupleContainer) {
		Iterator<Tuple> i_tupleContainer = tupleContainer.iterator();
		while (i_tupleContainer.hasNext()) {
			if (!containsTuple(i_tupleContainer.next())) {
				return false;
			}
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TupleContainer#iterator()
	 */
	public final Iterator<Tuple> iterator ( ) {
		return list.iterator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.AbstractTupleContainer#removeTuple(be.SIRAPRISE.client.AbstractTuple)
	 */
	public boolean removeTuple (Tuple t) {
		return list.remove(t);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TupleContainer#size()
	 */
	public final int size ( ) {
		return list.size();
	}
}