/*
 * Created on 7-aug-2008
 */
package be.SIRAPRISE.client;

import java.util.*;
import java.util.Map.Entry;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public class ClientTuple extends AbstractTuple {

	/**
	 * The map
	 */
	private IntersectableMap<String, ?> attributeValueMap;

	/**
	 * Map holding the attribute values in unescaped format. It holds only the attribute values that are effectively different between escaped and nonescaped representations, and the map is null if there are no such attributes at all
	 */
	private HashMap<String, String> unEscapedAttributeValueMap;

	/**
	 * Creates the tuple
	 * 
	 * @param attributeValueMap
	 * @param heading
	 */
	@SuppressWarnings("unchecked")
	public ClientTuple (IntersectableMap<String, ?> attributeValueMap, Heading heading) {
		super(heading);
		this.attributeValueMap = attributeValueMap;
		Iterator<?> i_attributeValueMap = attributeValueMap.entrySet().iterator();
		while (i_attributeValueMap.hasNext()) {
			Entry<String, ?> me = (Map.Entry<String, ?>) i_attributeValueMap.next();
			String attributeValue = (String) me.getValue();
			try {
				String unEscapedAttributeValue = BracketParser.unMeta(attributeValue);
				if (!unEscapedAttributeValue.equals(attributeValue)) {
					if (unEscapedAttributeValueMap == null) {
						unEscapedAttributeValueMap = new HashMap<String, String>();
					}
					String attributeName = me.getKey();
					unEscapedAttributeValueMap.put(attributeName, unEscapedAttributeValue);
				}
			} catch (InvalidEscapedCharacterException e) {
				throw new IllegalArgumentException(e.getClass().getName() + " : " + e.getMessage()); //$NON-NLS-1$
			} catch (MissingEscapedCharacterException e) {
				throw new IllegalArgumentException(e.getClass().getName() + " : " + e.getMessage()); //$NON-NLS-1$
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.Tuple#escapedValue(java.lang.String)
	 */
	public String escapedValue (String attributeName) {
		return (String) attributeValueMap.get(attributeName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.Tuple#rvaValue(java.lang.String)
	 */
	@Override
	public AbstractRelation rvaValue (String attributeName) {
		Heading heading = getHeading();
		TypeDeclaration attributeTypeDeclaration = heading.get(attributeName);
		if (attributeTypeDeclaration == null || !(attributeTypeDeclaration instanceof NonScalarTypeDeclaration)) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("ClientTuple.NotNonScalar"), new String[] { attributeName, heading.toString() })); //$NON-NLS-1$
		}
		NonScalarTypeDeclaration attributeNonScalarTypeDeclaration = (NonScalarTypeDeclaration) attributeTypeDeclaration;

		String escapedStringValue = escapedValue(attributeName).trim();

		// strip the BODY() header which is supposed to be there
		try {
			NameValueResult x = BracketParser.getNameValueFromEscaped(escapedStringValue, 0);
			if (x.getNameValuePair().getName().equalsIgnoreCase(NAMES.POSSREPCOMPONENTNAMES.BODY)) {
				escapedStringValue = x.getNameValuePair().getValue().trim();
			}
		} catch (NoClosingBracketException e) {
			throw new RuntimeException(e);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}

		// System.out.println(escapedStringValue);

		// Make the list of tuples
		LinkedList<String> tupleList;
		try {
			tupleList = BracketParser.createListFromEscaped(escapedStringValue);
		} catch (NoClosingBracketException e) {
			throw new RuntimeException(e);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (NoOpeningBracketException e) {
			throw new RuntimeException(e);
		}

		// System.out.println(tupleList);

		Heading rvaHeading = attributeNonScalarTypeDeclaration.getHeading();
		AbstractRelation r = new InsertionOrderRelation(rvaHeading);
		for (String tupleValueBody : tupleList) {
			// System.out.println(tupleValueBody);
			IntersectableMap<String, Object> m = new IntersectableHashMap<String, Object>();
			// fill the attribute value map
			try {
				int scanned = 0;
				while (scanned < tupleValueBody.length()) {
					NameValueResult nvr = BracketParser.getNameAndMandatoryValueFromEscaped(tupleValueBody, scanned);
					String rvaAttributeName = nvr.getNameValuePair().getName();
					String attributeValue = nvr.getNameValuePair().getValue();
					// System.out.println(rvaAttributeName + ':' + attributeValue);
					scanned = nvr.getNextParsePos();
					m.put(rvaAttributeName, attributeValue);
					// System.out.println(m);
				}
			} catch (NoClosingBracketException e) {
				throw new RuntimeException(e);
			} catch (InvalidEscapedCharacterException e) {
				throw new RuntimeException(e);
			} catch (MissingEscapedCharacterException e) {
				throw new RuntimeException(e);
			} catch (NoOpeningBracketException e) {
				throw new RuntimeException(e);
			}

			r.addTupleWithHeadingCheck(new ClientTuple(m, rvaHeading));
			// System.out.println(r);
		}

		return r;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.Tuple#value(java.lang.String)
	 */
	public String value (String attributeName) {
		return unEscapedAttributeValueMap == null ? escapedValue(attributeName) : (unEscapedAttributeValueMap.containsKey(attributeName) ? unEscapedAttributeValueMap.get(attributeName) : escapedValue(attributeName));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.Tuple#values()
	 */
	public IntersectableMap<?, ?> values ( ) {
		return attributeValueMap;
	}
}