/*
 * Created on 25-jul-2008
 */
package be.SIRAPRISE.client;

import be.erwinsmout.MyMessageFormat;

/**
 * A CommunicationProtocolException indicates that an unexpected message type has appeared in a communication scenario between a client and a SIRA_PRISE server, or that some problem has occurred which prevented the communication from succeeding (such as e.g. a Signature computation that failed for some reason).
 * 
 * @author Erwin Smout
 */
public class CommunicationProtocolException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6372944815008744271L;

	/**
	 * Creates the exception, setting a message that the messageType/version obtained from an InputStream did not match the expected message type.
	 * 
	 * @param messageType
	 *            The numeric ID of the message type expected.
	 * @param name
	 *            The classname of the message actually received from the stream
	 * @deprecated
	 */
	public CommunicationProtocolException (String name, int messageType) {
		super(MyMessageFormat.format(Messages.getString("CommunicationProtocolException.MessageTypeMismatch"), new Object[] { name, Integer.toHexString(messageType) })); //$NON-NLS-1$
	}

	/**
	 * Creates the exception, setting a message that the messageType/version obtained from an InputStream did not match the expected message type.
	 * 
	 * @param expectedType
	 *            The classname of the message expected by the system
	 * @param name
	 *            The classname of the message actually received from the stream
	 */
	public CommunicationProtocolException (String name, String expectedType) {
		super(MyMessageFormat.format(Messages.getString("CommunicationProtocolException.MessageTypeMismatch"), new Object[] { name, expectedType })); //$NON-NLS-1$
	}

	/**
	 * Creates the exception, setting a message that the given messageType/version was not found by the engine seeking it.
	 * 
	 * @param messageType
	 *            The numeric ID of the message type sought.
	 * @param fullMessageVersion
	 *            The number indicating the major and minor version numbers of the message type that was not found.
	 */
	public CommunicationProtocolException (int messageType, int fullMessageVersion) {
		super(MyMessageFormat.format(Messages.getString("CommunicationProtocolException.MessageTypeNotFound"), new Object[] { Integer.toHexString(messageType), new Version(fullMessageVersion) })); //$NON-NLS-1$
	}

	/**
	 * Creates the exception, setting a message that the cause of this exception is the other exception given as an argument here
	 * 
	 * @param msg
	 *            The basic message to be displayed
	 * @param cause
	 *            The exception that caused the need for this one to be thrown
	 */
	public CommunicationProtocolException (String msg, Exception cause) {
		super(msg + (cause == null ? "" : MyMessageFormat.format(Messages.getString("CommunicationProtocolException.CausedByException"), new String[] { cause.getClass().getName(), cause.getMessage() })), cause); //$NON-NLS-1$ //$NON-NLS-2$
	}
}