/*
 * Created on 26-jul-2008
 */
package be.SIRAPRISE.client;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

import be.erwinsmout.MyProperties;

/**
 * The DBConnectionProperties singleton holds the property values mentioned in the DBCONNECTION.PROPERTIES file. This DBCONNECTION.PROPERTIES can be held in the file system, or be packaged in a jar file that is on the client's classpath. If both are present, only the file in the file system is used. If no DBCONNECTION.PROPERTIES file exists in the file system, but multiple jars are on the classpath holding such a file, then which DBCONNECTION.PROPERTIES file is actually loaded is undetermined. This situation should be avoided.
 * 
 * @author Erwin Smout
 */
public class DBConnectionProperties extends MyProperties {

	/**
	 * the instance
	 */
	private static final Properties instance = new DBConnectionProperties();

	/**
	 * 
	 */
	private static final long serialVersionUID = -3847788384670732516L;

	/**
	 * The name of the property used to indicate the set of crypto algorithm names that can be used by a client
	 */
	public static final String CRYPTOALGORITHMS = "CRYPTOALGORITHMS"; //$NON-NLS-1$

	/**
	 * The name of the property that specifies the (default) transaction autocommit setting for all connections created using a constructor that does not explicitly provide this information. Note that this value can still be "overridden" if a transaction is started using an explicitly specified autocommit setting in the startTransaction() invocation.
	 */
	public static final String DEFAULTAUTOCOMMITFORTRANSACTIONS = "DEFAULTAUTOCOMMITFORTRANSACTIONS"; //$NON-NLS-1$

	/**
	 * The property name for specifying the connection idle time for all connections created using a DBConnection constructor that does not specify an explicit idle time.
	 */
	public static final String DEFAULTCONNECTIONIDLETIME = "DEFAULTCONNECTIONIDLETIME"; //$NON-NLS-1$

	/**
	 * The name of the property that specifies which ciphers will be used by connections that are created by a constructor that did not explicitly provide this information
	 */
	public static final String DEFAULTENCRYPTIONALGORITHMNAMES = "DEFAULTENCRYPTIONALGORITHMNAMES"; //$NON-NLS-1$

	/**
	 * The value used for the DEFAULTENCRYPTIONALGORITHMNAMES property if no value is explicitly configured
	 */
	public static final String DEFAULTENCRYPTIONALGORITHMNAMESDEFAULT = "SPE"; //$NON-NLS-1$

	/**
	 * The name of the property that specifies which signature algorithms can be employed by a DBConnection that is created using a constructor that does not explicitly provide this information.
	 */
	public static final String DEFAULTSIGNATUREALGORITHMNAMES = "DEFAULTSIGNATUREALGORITHMNAMES"; //$NON-NLS-1$

	/**
	 * The default value for the signature algorithms list that will be used for the DEFAULTSIGNATUREALGORITHMNAMES property, if no value is configured
	 */
	public static final String DEFAULTSIGNATUREALGORITHMNAMESDEFAULT = "SPS, MD5WITHRSA, MD2WITHRSA, SHA1WITHRSA, SHA1WITHDSA"; //$NON-NLS-1$

	/**
	 * The property name for specifying the host to which a client is to connect
	 */
	public static final String HOST = "HOST"; //$NON-NLS-1$

	/**
	 * The default value for the HOST property
	 */
	public static final String HOSTDEFAULT = "127.0.0.1"; //$NON-NLS-1$

	/**
	 * 
	 */
	public static final String MONITORPORT = "MONITORPORT"; //$NON-NLS-1$

	/**
	 * 
	 */
	public static final String MONITORPORTDEFAULT = "50002"; //$NON-NLS-1$

	/**
	 * The property name for specifying the IP port on some host to which SIRA_PRISE clients are to connect
	 */
	public static final String PORT = "PORT"; //$NON-NLS-1$

	/**
	 * The default value for the PORT property
	 */
	public static final String PORTDEFAULT = "50000"; //$NON-NLS-1$

	/**
	 * The name of the property used to indicate the set of signing algorithm names that can be used by a client
	 */
	public static final String SIGNINGALGORITHMS = "SIGNINGALGORITHMS"; //$NON-NLS-1$

	/**
	 * The name of the property that specifies the (default !) read-only mode setting for all transactions started on a connection created using a constructor that does not explicitly state this value.
	 */
	public static final String TRANSACTIONSREADONLY = "TRANSACTIONSREADONLY"; //$NON-NLS-1$

	/**
	 * The property name for specifying the user that will be owning the transactions started by some client
	 */
	public static final String USER = "USER"; //$NON-NLS-1$

	/**
	 * The default value for the USER property
	 */
	public static final String USERDEFAULT = ""; //$NON-NLS-1$

	/**
	 * The name for the property configuring the DBConnection-level default DDLCAPTURE setting for transactions started by methods not explicitly providing this setting
	 */
	public static final String DDLCAPTURE = "DDLCAPTURE"; //$NON-NLS-1$

	/**
	 * Gets a Set of supported crypto algorithm names out of a comma-separated list of such names.
	 * 
	 * @param cryptoAlgorithmNameList
	 *            A textual specification in the form of a comma-separated list of Cipher names
	 * @return a Set of supported crypto algorithm names out of a comma-separated list of such names.
	 */
	public static Set<String> getCryptoAlgorithmNameSet (String cryptoAlgorithmNameList) {
		Set<String> cryptoAlgorithmNameSet = new HashSet<String>();

		if (cryptoAlgorithmNameList.length() > 0) {
			// Value is supposed to be a comma-separated list of encryption protocol names
			String[] cryptoAlgorithmNames_tx = cryptoAlgorithmNameList.split(","); //$NON-NLS-1$
			int i = 0;
			while (i < cryptoAlgorithmNames_tx.length) {
				String cryptoAlgorithmName = cryptoAlgorithmNames_tx[i++].trim().toUpperCase();
				if (cryptoAlgorithmName.equalsIgnoreCase("SPE")) { //$NON-NLS-1$
					try {
						// Check if the Cipher is installed
						DBConnectionProperties.class.getClassLoader().loadClass("be.SIRAPRISE.security." + cryptoAlgorithmName); //$NON-NLS-1$
						cryptoAlgorithmNameSet.add(cryptoAlgorithmName);
					} catch (ClassNotFoundException e2) {

					}
				} else {
					try {
						// Check if the Cipher is installed
						Cipher.getInstance(cryptoAlgorithmName);
						cryptoAlgorithmNameSet.add(cryptoAlgorithmName);
					} catch (NoSuchAlgorithmException e) {

					} catch (NoSuchPaddingException e) {

					}
				}
			}
		}

		return cryptoAlgorithmNameSet;
	}

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	public static Properties getInstance ( ) {
		return instance;
	}

	/**
	 * Gets a Set of supported signing algorithm names out of a comma-separated list of such names.
	 * 
	 * @param clientSigningAlgorithmNameList
	 *            A comma-separated list of Signature names.
	 * @return a Set of supported signing algorithm names out of a comma-separated list of such names.
	 */
	public static Set<String> getSigningAlgorithmNameSet (String clientSigningAlgorithmNameList) {
		Set<String> algorithmNameSet = new HashSet<String>();

		// Process the list of client signature algorithms and set the set
		if (clientSigningAlgorithmNameList.length() > 0) {
			// Value is supposed to be a comma-separated list of signing protocol names
			String[] clientSigningAlgorithmNames_tx = clientSigningAlgorithmNameList.split(","); //$NON-NLS-1$
			int i = 0;
			while (i < clientSigningAlgorithmNames_tx.length) {
				String clientSigningAlgorithmName = clientSigningAlgorithmNames_tx[i++].trim().toUpperCase();
				try {
					// Check if the signature algorithm is installed
					Signature.getInstance(clientSigningAlgorithmName);
					algorithmNameSet.add(clientSigningAlgorithmName);
				} catch (NoSuchAlgorithmException e) {

				}
			}
		}

		return algorithmNameSet;
	}

	/**
	 * 
	 */
	private DBConnectionProperties ( ) {
		super(true);
	}
}