/*
 * Created on 11-okt-2006
 */
package be.SIRAPRISE.client;

/**
 * A DBException is thrown by DBConnection's communication methods when the sira_prise server has reported any kind of error.
 * 
 * @author Erwin Smout
 */
public class DBException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2514060383420476028L;

	/**
	 * The error number ; -1 if there is no meaningful information here (such as in the case of a contradiction exception, or a system runtime error)
	 */
	private long errorCode = -1;

	/**
	 * @param e
	 */
	DBException (Exception e) {
		super(e);
	}

	/**
	 * @param e
	 */
	DBException (ErrorMessageException e) {
		this(e.getServerErrorMessage().getOriginalExceptionMessage(), e.getServerErrorMessage().getErrorNumber());
	}

	/**
	 * Creates the response object
	 * 
	 * @param msg
	 *            the response message to be set
	 */
	DBException (String msg) {
		super(msg);
	}

	/**
	 * Creates the response object
	 * 
	 * @param responseText
	 *            the response message to be set
	 * @param errorCode
	 *            The error number to be set
	 */
	DBException (String responseText, long errorCode) {
		super(responseText);
		this.errorCode = errorCode;
	}

	/**
	 * Gets the error number.
	 * 
	 * @return The error number ; -1 if there is no meaningful information here (such as in the case of a contradiction exception, or a system runtime error)
	 */
	public long getErrorCode ( ) {
		return errorCode;
	}
}