/**
 * 
 */
package be.SIRAPRISE.client;

/**
 * @author Erwin
 * 
 */
public final class DDLCapture {

	/**
	 * 
	 */
	private static final int _OFF = 0;

	/**
	 * 
	 */
	private static final int _ON = 1;

	/**
	 * 
	 */
	private static final String[] strings = new String[] { "No DDL capture", "With DDL capture" }; //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * 
	 */
	public static final DDLCapture OFF = new DDLCapture(_OFF);

	/**
	 * 
	 */
	public static final DDLCapture ON = new DDLCapture(_ON);

	/**
	 * Gets the DDLCapture object corresponding to the specified capturing mode (ON/OFF for true/false, repsectively)
	 * 
	 * @param b
	 *            flag indicating which capturing mode is to be returned
	 * @return the DDLCapture object corresponding to the specified capturing mode (ON/OFF for true/false, repsectively)
	 */
	public static DDLCapture getDDLCapture (boolean b) {
		return b ? ON : OFF;
	}

	/**
	 * the numeric value for this object of the enum
	 */
	private int num;

	/**
	 * Creates the DDLCapture
	 * 
	 * @param num
	 *            the numeric value for this object of the enum
	 */
	private DDLCapture (int num) {
		this.num = num;
	}

	/**
	 * Checks whether this DDLCapture represents the "capturing ON" mode
	 * 
	 * @return true if this DDLCapture object represents the ddl capturing mode in which ddl capturing is effectively performed
	 */
	public boolean isCapturingDDL ( ) {
		return num == _ON;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return strings[num];
	}
}
